﻿# graphcoul_01_07.py       construction et réduction d'un
# graphe pour le nombre minimal de colorations
# 09/06/2025



from tkinter import *
from tkinter.font import Font
from math import *
import os.path

dim_x=1000       # dimensions de la fenêtre  800
dim_y=880
ech_px=600   #echelle : nombre de pixels pour un mètre  900
#coefpixpoint=0.000369244  # dimension d'un pixel vidéo
coefpixpoint=0.0005274725
delta_rideau_x=0
delta_rideau_y=5.782725391e-6  # duree du balayage vertical video pour une ligne en seconde


class Point_rond(object):
    "Point geométrique"
    delta_x=5   # demi-dimension de la croix pour le point
    def __init__(self,coordonnees,ind,texte,nb_noeuds,rayon=5,epaiss=1,couleur='black'):
        "création d'un point"
        self.x=coordonnees[0]
        self.y=coordonnees[1]
        self.coul=couleur
        self.ep=epaiss
        self.ind=ind
        self.texte=texte
        self.t=None
        self.nb_noeuds=nb_noeuds
        self.lx=None
        self.ly=None
        self.oval=None
        self.rayon=rayon
        self.tcom=None
        self.existe=1

    def trace(self):
        "tracé d'un point"
        if self.existe==1:
            self.oval=can1.create_oval(self.x-self.rayon,self.y-self.rayon,self.x+self.rayon,self.y+self.rayon, width=self.ep, fill=self.coul)
            font = Font(family='Arial', size=12)
            if 4*self.ind<self.nb_noeuds:
                y_texte = self.y-25
                x_texte = self.x+25
            elif 2*self.ind < self.nb_noeuds :
                y_texte = self.y+25
                x_texte = self.x+25
            elif 4*self.ind< 3*self.nb_noeuds:
                y_texte = self.y+25
                x_texte = self.x-25
            else :
                y_texte = self.y-25
                x_texte = self.x-25

            self.t=can1.create_text(x_texte, y_texte, text=self.texte, font=font, fill='#000080' )    # anchor='w'

    def detruit(self):
        "détruit le tracé du point"
        can1.delete(self.t)
        can1.delete(self.oval)
        can1.delete(self.tcom)
        #self.existe=0
    def detruit2(self):
        self.existe=0

    def change_coul(self,couleur,epaiss):
        self.coul=couleur
        self.ep=epaiss
        self.detruit()
        self.trace()

    def com(self,ncom):
        if 4*self.ind<self.nb_noeuds:
            y_texte = self.y+25
            x_texte = self.x+25
        elif 2*self.ind < self.nb_noeuds :
            y_texte = self.y+50
            x_texte = self.x+25
        elif 4*self.ind< 3*self.nb_noeuds:
            y_texte = self.y+50
            x_texte = self.x-25
        else :
            y_texte = self.y-50
            x_texte = self.x-25


        font = Font(family='Arial', size=12)


        self.tcom=can1.create_text(x_texte, y_texte, text=str(ncom), font = font, fill='#0000FF')

    def delcom(self):
        can1.delete(self.tcom)

class Arete(object):
    "vecteur"
    def __init__(self,pr1,pr2,couleur='black',epaiss=1):
        "création d'un vecteur"
        self.existe=1
        self.pr1=pr1
        self.pr2=pr2
        self.coul=couleur
        self.ep=epaiss
        self.ligne=None
        self.d=sqrt((self.pr1.x-self.pr2.x)**2+(self.pr1.y-self.pr2.y)**2)
        if self.d<1e-20:
            self.d=1e-20


    def trace(self):
        "tracé d'une arete"
        self.ligne=can1.create_line(self.pr1.x,self.pr1.y,self.pr2.x,self.pr2.y,fill=self.coul,width=self.ep)

    def detruit(self):
        "effacement d'une arete"
        can1.delete(self.ligne)

    def change_coul(self,couleur,epaiss):
        self.coul=couleur
        self.ep=epaiss
        self.detruit()
        self.trace()

    def detruit2(self):
        self.existe=0


def pointeur2(event):
    "sélection d un point ou d un vecteur avec la souris"
    "Action sur un Clic-Gauche de souris"
    global psel, psel2, drapeau_sel_pt, drapeau_sel_pt2, list_pr, list_ok, matrice, drapeau_sel_vect,vsel,drapeau_sel_pt_ext,numero_trace
    pos_x=event.x
    pos_y=event.y
    if drapeau_man==0 :        # tracer du graphe
        if drapeau_sel_pt==1:
            psel.change_coul('red',5)
            drapeau_sel_pt=0

        if drapeau_sel_pt2==1:
            psel2.change_coul('red',5)
            drapeau_sel_pt2=0


        # on construit le graphe
        for pr in list_pr:
                # on cherche un point
                d=dist((pos_x,pos_y),(pr.x,pr.y))
                if (d<delta_pt):
                    psel=pr
                    drapeau_sel_pt=1
                    break
        if drapeau_sel_pt==1:
            psel.change_coul('green',5)
    elif drapeau_man==1 :        # reduction du graphe
        if drapeau_sel_pt==1:
            psel.change_coul('red',5)
            drapeau_sel_pt=0

        if drapeau_sel_pt2==1:
            psel2.change_coul('red',5)
            drapeau_sel_pt2=0


        # on construit le graphe
        for pr in list_pr:
                # on cherche un point
                d=dist((pos_x,pos_y),(pr.x,pr.y))
                if (d<delta_pt):
                    psel=pr
                    drapeau_sel_pt=1
                    break
        if drapeau_sel_pt==1:
            psel.change_coul('green',5)
            list_ok=[]
            for pr in list_pr:
                if matrice[pr.ind][psel.ind]==0 and pr.ind != psel.ind :
                    list_ok.append(pr)
                    pr.change_coul('blue',5)
                elif  pr.ind != psel.ind :
                    pr.change_coul('red',5)
            for pr in list_pr:
                pr.delcom()
            for pr in list_ok:
                nbcom=[]
                tot=0
                for p2 in list_pr :
                    if matrice[pr.ind][p2.ind]==1 and matrice[psel.ind][p2.ind]==1:
                        tot+=1
                nbcom.append(tot)
                pr.com(tot)






def shift_pointeur2(event):
    "Action sur un Majuscule-Clic-Gauche de souris"
    global psel, psel2, drapeau_sel_pt, drapeau_sel_pt2, matrice, list_ok, liste_noeuds, nb_noeuds
    pos_x=event.x
    pos_y=event.y
    if drapeau_sel_pt2==1:
        drapeau_sel_pt2=0
        psel2.change_coul('red',5)

    if drapeau_man==0:
        if drapeau_sel_pt==1:

            # on construit le graphe
            for pr in list_pr:
                # on cherche un point
                d=dist((pos_x,pos_y),(pr.x,pr.y))
                if (d<delta_pt):
                    psel2=pr
                    drapeau_sel_pt2=1
                    break
            if drapeau_sel_pt2==1:
                psel2.change_coul('blue',5)
                arete=Arete(psel,psel2,'green',2)
                for ar in list_ar:
                    if ar.existe==1:
                        ar.change_coul('black',2)
                arete.trace()
                list_ar.append(arete)
                matrice[arete.pr1.ind][arete.pr2.ind]=1
                matrice[arete.pr2.ind][arete.pr1.ind]=1

    if drapeau_man==1:
        if drapeau_sel_pt==1:

            # on reduit le graphe
            for pr in list_ok:
                # on cherche un point
                d=dist((pos_x,pos_y),(pr.x,pr.y))
                if (d<delta_pt):
                    psel2=pr
                    drapeau_sel_pt2=1
                    break
            if drapeau_sel_pt2==1 :               #  and matrice[psel.ind][psel2.ind]==0 dans list_ok :
                psel2.change_coul('green',5)
                # on reduit le graphe
                # on efface
                for ar in list_ar :
                    ar.detruit()
                    ar.detruit2()
                for pr in list_pr:
                    pr.detruit()
                    pr.detruit2()
                list_pr2=[]
                liste_noeuds2=[]
                for pr in list_pr:
                    if pr.ind != psel2.ind and pr.ind != psel.ind :
                        liste_noeuds2.append(liste_noeuds[pr.ind])
                    elif pr.ind==psel.ind:
                        liste_noeuds2.append(liste_noeuds[psel.ind]+'_'+liste_noeuds[psel2.ind])
                matrice2=[]
                for i in range(nb_noeuds-1):
                    matrice2.append([])
                    for j in range(nb_noeuds-1):
                        matrice2[i].append(0)
                if psel.ind < psel2.ind :
                    for i in range(psel2.ind):                 #1
                        for j in range(psel2.ind):
                            matrice2[i][j]=matrice[i][j]
                    for i in range(psel2.ind,nb_noeuds-1):     #2
                        for j in range (psel2.ind):
                            matrice2[i][j]=matrice[i+1][j]
                    for i in range(psel2.ind):                  #3
                        for j in range(psel2.ind, nb_noeuds-1):
                            matrice2[i][j]=matrice[i][j+1]
                    for i in range(psel2.ind,nb_noeuds-1):       #4
                        for j in range(psel2.ind,nb_noeuds-1):
                            matrice2[i][j]=matrice[i+1][j+1]
                    for j in range(psel2.ind):                                        #5
                        if matrice[psel.ind][j]==1 or matrice[psel2.ind][j]==1 :
                            matrice2[psel.ind][j]=1
                    for j in range(psel2.ind,nb_noeuds-1):                              #6
                        if matrice[psel.ind][j+1]==1 or matrice[psel2.ind][j+1]==1 :
                            matrice2[psel.ind][j]=1
                    for i in range(psel2.ind):                                        #7
                        if matrice[i][psel.ind]==1 or matrice[i][psel2.ind]==1 :
                            matrice2[i][psel.ind]=1
                    for i in range(psel2.ind,nb_noeuds-1):                               #8
                        if matrice[i+1][psel.ind]==1 or matrice[i+1][psel2.ind]==1 :
                            matrice2[i][psel.ind]=1

                    matrice2[psel.ind][psel.ind]=0            #9

                else :
                    for i in range(psel2.ind):                           #1
                        for j in range(psel2.ind):
                            matrice2[i][j]=matrice[i][j]
                    for i in range(psel2.ind,nb_noeuds-1):           #2
                        for j in range(psel2.ind):
                            matrice2[i][j]=matrice[i+1][j]
                    for i in range(psel2.ind):                    #3
                        for j in range(psel2.ind,nb_noeuds-1):
                            matrice2[i][j]=matrice[i][j+1]
                    for i in range(psel2.ind,nb_noeuds-1):          #4
                        for j in range(psel2.ind,nb_noeuds-1):
                            matrice2[i][j]=matrice[i+1][j+1]
                    for j in range(psel2.ind):                                       #5
                        if matrice[psel.ind][j]==1 or matrice[psel2.ind][j]==1 :
                            matrice2[psel.ind-1][j]=1
                    for j in range(psel2.ind,nb_noeuds-1):                           #6
                        if matrice[psel.ind][j+1]==1 or matrice[psel2.ind][j+1]==1 :
                            matrice2[psel.ind-1][j]=1
                    for i in range(psel2.ind):                                       #7
                        if matrice[i][psel.ind]==1 or matrice[i][psel2.ind]==1 :
                            matrice2[i][psel.ind-1]=1
                    for i in range(psel2.ind,nb_noeuds-1):                           # 8
                        if matrice[i+1][psel.ind]==1 or matrice[i+1][psel2.ind]==1 :
                            matrice2[i][psel.ind-1]=1

                    matrice2[psel.ind-1][psel.ind-1]=0

                matrice=[]
                for i in range(nb_noeuds-1):
                    matrice.append([])
                    for j in range(nb_noeuds-1):
                        matrice[i].append(matrice2[i][j])

                liste_noeuds=[]
                nb_noeuds=nb_noeuds-1
                for i in range(nb_noeuds):
                    liste_noeuds.append(liste_noeuds2[i])
                trace_noeuds()
                for i in range(nb_noeuds):
                    for j in range(i,nb_noeuds):
                        #if int(matrice[i][j])==1:
                        if matrice[i][j]==1:
                            ar=Arete(list_pr[i],list_pr[j],'black',2)
                            ar.trace()
                            list_ar.append(ar)








def moins_arete2(event):
    "suppression de l'arete par Clic-Droit"
    global matrice
    drapeau_sel_vect=0
    pos_x=event.x
    pos_y=event.y
    if drapeau_man==0:   # creation du graphe
            for ar in list_ar:
                det=(pos_x-ar.pr1.x)*(pos_y-ar.pr2.y)-\
                (pos_y-ar.pr1.y)*(pos_x-ar.pr2.x)         # déterminant pour tester l'alignement
                d1=dist((pos_x,pos_y),(ar.pr1.x,ar.pr1.y)) # P appartient au segmnt ?
                d2=dist((pos_x,pos_y),(ar.pr2.x,ar.pr2.y))
                d3=ar.d
                #print("d1 = ",d1, " d2 = ",d2," d3 = ",d3," det = ", det," delta_vect2 = ",delta_vect2," delta_vect_ext = ",delta_vect_ext)
                if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
                d2>delta_vect_ext and d1<d3 and d2<d3 and ar.existe==1:
                    arsel=ar
                    drapeau_sel_vect=1

                    break
            if drapeau_sel_vect==1:
                arsel.detruit()   # efface
                arsel.detruit2()  # considere comme n'existant plus
                arsel.pr1.change_coul('red',5)
                arsel.pr2.change_coul('red',5)
                matrice[arsel.pr1.ind][arsel.pr2.ind]=0
                matrice[arsel.pr2.ind][arsel.pr1.ind]=0



def choix_vecteur2():
    "Action des boutons radio pour la sélection d'un vecteur"
    global l_coul, drapeau_man
    numero_vecteur=type_vecteur.get()
    if numero_vecteur==0:
        drapeau_man=0
    elif numero_vecteur==1:
        drapeau_man=1
    else:
        drapeau_man=4


def dist(A,B):
    "Calcul de la distance entre 2 points"
    return sqrt((A[0]-B[0])**2+(A[1]-B[1])**2)

def dist2(A,B):
    "Calcul de la distance au carré"
    return (A[0]-B[0])**2+(A[1]-B[1])**2

def e_f():
    global matrice, nb_noeuds, etat_avance

    nbfic=int(entree3.get())
    nbfic=nbfic+1
    entree3.delete(0,END)
    entree3.insert(0,str(nbfic))
    cf=open('configgraph.txt','w')
    cf.write(str(nbfic)+'\nNumero du dernier fichier graphe créé')
    cf.close()
    fw=open('graphe'+str(nbfic)+'.txt','w')
    fw.write('Ceci est le contenu du fichier graphe'+str(nbfic)+'.txt,\n')
    fw.write('pour trouver les colorations\n')
    fw.write('Ce fichier contient le nombre et les noms des noeuds du graphe.\n')
    fw.write('A l étape 1, on crée les aretes et la matrice. A l étape 2 on réduit le graphe.\n')
    if etat_avance==2:
        #fw.write(str(nb_noeuds)+'\n')
        fw.write(commentaire+'\n')
        for i in range(nb_noeuds):
            fw.write(liste_noeuds[i]+";")
        fw.write('\nCode avancement : 1 : création des aretes et de la matrice. 2 : matrice crée.\n')
        fw.write(str(etat_avance)+'\n')
        for i in range(nb_noeuds):
            for j in range(nb_noeuds):
                fw.write(str(matrice[i][j])+";")
            fw.write("\n")
    fw.close()

def efface_tout():
    global list_ar, list_pr,nb_noeuds,liste_noeuds
    for ar in list_ar:
        ar.detruit()
        ar.detruit2()
    for pr in list_pr:
        pr.detruit()
        pr.detruit2()
    nb_noeuds=0
    liste_noeuds=[]
    liste_ar=[]
    liste_pr=[]



def trace_noeuds():
    global nb_noeuds, liste_noeuds, list_pr,list_ar
    centrex=dim_x//2
    centrey=dim_y//2
    rayon=dim_y//2-80
    #oval1=[]
    xnoeud=[]
    ynoeud=[]
    list_pr=[]   # liste des points ronds = noeuds du graphe
    list_ar=[]   #  liste des aretes du graphe
    rayon2=8
    epaiss=4


    for i in range(nb_noeuds):
        xnoeud.append(int(centrex+rayon*sin(2*pi/nb_noeuds*i)))
        ynoeud.append(int(centrey-rayon*cos(2*pi/nb_noeuds*i)))
        #oval1.append(0)
        #oval1[i]=can1.create_oval(xnoeud[i]-5,ynoeud[i]-5,xnoeud[i]+5,ynoeud[i]+5, width=2, fill='red')
        texte =liste_noeuds[i]
        pr=Point_rond((xnoeud[i],ynoeud[i]),i,texte,nb_noeuds,rayon2,epaiss,'red')
        #def __init__(self,coordonnees,ind,texte,nb_noeuds,rayon=5,epaiss=1,couleur='black'):
        pr.trace()
        list_pr.append(pr)



def o_f():
    global nb_noeuds, liste_noeuds, etat_avance, matrice, list_ar,commentaire
    nbfic=int(entree3.get())
    if nbfic!=0:
        fr=open('graphe'+str(nbfic)+'.txt','r')
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        #lire=fr.readline()
        #nb_noeuds=int(lire[0:-1])
        commentaire=lire[0:-1]
        lire=fr.readline()
        lire=lire[0:-2]
        liste_noeuds=lire.split(";")
        nb_noeuds=len(liste_noeuds)
        print("test liste des noms des noeuds")
        for i in range(nb_noeuds):
            print(i," nom du noeud ",i," : ",liste_noeuds[i])
        lire=fr.readline()
        lire=fr.readline()
        print("etat avance (1, 2) : ",lire)
        etat_avance=int(lire[0:-1])
        if etat_avance==1:
            trace_noeuds()
            matrice=[]
            for i in range(nb_noeuds):
                matrice.append([])
                for j in range(nb_noeuds):
                    matrice[i].append(0)
            etat_avance=2                      # on considere que la matrice est cree

        elif etat_avance==2:
            trace_noeuds()
            matrice=[]
            for i in range(nb_noeuds):
                lire=fr.readline()
                lire=lire[0:-2]
                matrice.append([])
                matrice[i]=lire.split(";")
            for i in range (nb_noeuds):
                for j in range(nb_noeuds):
                    matrice[i][j]=int(matrice[i][j])
            for i in range(nb_noeuds):
                for j in range(i,nb_noeuds):
                    #if int(matrice[i][j])==1:
                    if matrice[i][j]==1:
                        ar=Arete(list_pr[i],list_pr[j],'black',2)
                        ar.trace()
                        list_ar.append(ar)
        fr.close()

class AutoScrollbar(Scrollbar):
    # a scrollbar that hides itself if it's not needed.  only
    # works if you use the grid geometry manager.
    def set(self, lo, hi):
        if float(lo) <= 0.0 and float(hi) >= 1.0:
            # grid_remove is currently missing from Tkinter!
            self.tk.call("grid", "remove", self)
        else:
            self.grid()
        Scrollbar.set(self, lo, hi)

class MaFrame(Frame) :
    def __init__(self, parent) :
        self._vscrollbar = AutoScrollbar(parent)
        self._vscrollbar.grid(row=0, column=1, sticky=NS)
        self._hscrollbar = AutoScrollbar(parent, orient=HORIZONTAL)
        self._hscrollbar.grid(row=1, column=0, sticky=EW)
        self._can = Canvas(parent, bg='white',
                              yscrollcommand=self._vscrollbar.set,
                              xscrollcommand=self._hscrollbar.set)

        self._can.grid(row=0, column=0, sticky=NSEW)
        self._vscrollbar.config(command=self._can.yview)
        self._hscrollbar.config(command=self._can.xview)

        super().__init__(self._can)
        self._can.create_window(0, 0, anchor=NW, window=self, state=NORMAL)
        self.bind('<Configure>', self._actualiserDimension)

    def _actualiserDimension(self, evt) :
        self._can.config(scrollregion=self._can.bbox("all"))

    def grid(self, **dargs) :
        ''' Ne pas grid la Frame '''
        pass

# Programme principal

root=Tk()
root.grid_rowconfigure(0, weight=1)
root.grid_columnconfigure(0, weight=1)
ws = root.winfo_screenwidth() # width of the screen
hs = root.winfo_screenheight() # height of the screen
fen1 = MaFrame(root)
root.geometry("%dx%d+%d+%d" % (ws-45, hs-90, 0, 0))
drapeau_sel_vect=0

drapeau_man=0   # pour la création d'un point ou d'un vecteur par ses coordonnées
drapeau_sel_pt=0  # 1 si un point est sélectionné
drapeau_sel_pt2=0  #    point d'arrivee de l'arete selectionne
drapeau_sel_pt_ext=0  # 1 si un point extremite de vecteur est sélectionné
#psel=Point((0,0))   # point selectionné
delta_pt=8  # distance pour sélectionner un point en pixel 4
delta_pt2=delta_pt**2



delta_vect_ext=2  # distance des extrémités pour ne pas sélectionner un vecteur 12
delta_vect_ext2=delta_vect_ext**2




delta_vect=60  # pour tester la nullité du déterminant pour sélectionner un vecteur  20
delta_vect2=delta_vect*delta_vect  # pour le déterminant




drapeau=0
drapeau_p=0
drapeau_k=0
drapeau_t=0
drapeau_pp=0
can1=Canvas(fen1,bg='dark grey',height=dim_y,width=dim_x)
can1.grid(column=0,row=0,rowspan=15)
bou1=Button(fen1,text='Quitter', width=8,command=fen1.quit)
bou1.grid(row=11,column=2)
bou2=Button(fen1, text='Effacer tout',width=12,command=efface_tout)
bou2.grid(row=11, column =4)
type_trace=IntVar()
type_trace.set(0)
numero_trace=0
numero_trace_sim=0
numero_trace_exp=1
larg=True
bou10=Button(fen1,text='Ouvrir graph_nn.txt',width=18,command=o_f)
bou10.grid(row=13,column=4)
bou11=Button(fen1,text='Enregistrer graph_nn+1.txt',width=20,command=e_f)
bou11.grid(row=13,column=2)
type_vecteur=IntVar()
type_vecteur.set(0)
choix_tout=Radiobutton(fen1,text='Créer le graphe',variable=type_vecteur,value=0,command=choix_vecteur2)
choix_depla=Radiobutton(fen1,text='Réduction du graphe',variable=type_vecteur,value=1,command=choix_vecteur2)
choix_tout.grid(row=4,column=1)
choix_depla.grid(row=4,column=4)
can1.bind("<Button-1>",pointeur2)
can1.bind("<Shift-Button-1>",shift_pointeur2)
can1.bind('<Button-3>',moins_arete2)
#icblu=0
#point_x=[]
#point_y=[]
#chaine_x=""
#chaine_y=""
entree3=Entry(fen1,width=10)
entree3.grid(row=13,column=5)

cond_conf=os.path.isfile('configgraph.txt')
if cond_conf:
    cf=open('configgraph.txt','r')
    nbfic=int(cf.readline())
    entree3.insert(0,str(nbfic))
    cf.close()
else:
    cf=open('configgraph.txt','w')
    nbfic=0
    entree3.insert(0,str(nbfic))
    cf.write('0\nNumero du dernier fichier graphe créé')
    cf.close()

nb_exp=0   # init nombre de points experimentaux
axx=[0]
ayy=[0]
root.mainloop()
root.destroy()