﻿#  masse ressorts x et y : affichage des composantes des vecteurs. Conditions initiales en polaires. Echelle plus grande.
# mecalab_05 : on peut tracer un vecteur arbitraire. Projection sur un vecteur CTRL - Shift -Clic - Gauche ou Droit

from tkinter import *
from math import *
#from random import randrange
class Point(object):
    "Point geométrique"
    delta_x=5   # demi-dimension de la croix pour le point
    def __init__(self,coordonnees,couleur='black',epaiss=1):
        "création d'un point"
        self.x=coordonnees[0]
        self.y=coordonnees[1]
        self.coul=couleur
        self.ep=epaiss
        self.lx=None
        self.ly=None

    def trace(self):
        "tracé d'un point"
        self.ly=can1.create_line(int(ech_px*self.x),int(ech_px*self.y)-Point.delta_x,int(ech_px*self.x),int(ech_px*self.y)+Point.delta_x,fill=self.coul,width=self.ep)
        self.lx=can1.create_line(int(ech_px*self.x)-Point.delta_x,int(ech_px*self.y),int(ech_px*self.x)+Point.delta_x,int(ech_px*self.y),fill=self.coul,width=self.ep)

    def detruit(self):
        "détruit le tracé du point"
        can1.delete(self.lx)
        can1.delete(self.ly)

    def change_coul(self,couleur,epaiss):
        self.coul=couleur
        self.ep=epaiss
        self.detruit()
        self.trace()


def detruit_dernier():
    global list_p
    for p in list_p:
        p.detruit()
def visualisation_points():
    global list_p
    for p in list_p:
        p.trace()

class Vecteur(object):
    "vecteur"
    def __init__(self,A=(0,0),B=(0,0),couleur='black',lpointe=5):
        "création d'un vecteur"
        self.x=B[0]-A[0]
        self.y=B[1]-A[1]
        self.P1=A
        self.P2=B
        self.coul=couleur
        self.lp=lpointe
        self.d=sqrt((self.x)**2+(self.y)**2)
        if self.d<1e-20:
            self.d=1e-20
        self.cosalpha=self.y/self.d
        self.sinalpha=self.x/self.d
        self.cosalpha2=rac2*self.cosalpha+rac2*self.sinalpha
        self.sinalpha2=rac2*self.sinalpha-rac2*self.cosalpha
        self.cosalpha3=rac2*self.cosalpha-rac2*self.sinalpha
        self.sinalpha3=rac2*self.sinalpha+rac2*self.cosalpha
        self.pte1x=self.lp*self.cosalpha2
        self.pte1y=self.lp*self.sinalpha2
        self.pte2x=self.lp*self.cosalpha3
        self.pte2y=self.lp*self.sinalpha3

    def trace(self,couleur,epaiss):
        "tracé d'un vecteur"
        self.lvect=can1.create_line(int(ech_px*self.P1[0]),int(ech_px*self.P1[1]),int(ech_px*self.P2[0]),int(ech_px*self.P2[1]),fill=couleur,width=epaiss)
        self.lpte1=can1.create_line(int(ech_px*self.P2[0]),int(ech_px*self.P2[1]),int(ech_px*self.P2[0]-self.pte1x),int(ech_px*self.P2[1]+self.pte1y),fill=couleur,width=epaiss)
        self.lpte2=can1.create_line(int(ech_px*self.P2[0]),int(ech_px*self.P2[1]),int(ech_px*self.P2[0]+self.pte2x),int(ech_px*self.P2[1]-self.pte2y),fill=couleur,width=epaiss)

    def desel(self):
        "déselection d'un vecteur"
        self.detruit()
        Vecteur.trace(self,self.coul,1)

    def selvect(self):
        "sélection d'un vecteur"
        self.detruit()
        Vecteur.trace(self,'dark green',2)

    def detruit(self):
        "effacement d'un vecteur"
        can1.delete(self.lvect)
        can1.delete(self.lpte1)
        can1.delete(self.lpte2)


def stop_it():
    global drapeau
    drapeau=0

def start_it():
    global drapeau
    if drapeau==0:
        drapeau=1
        calc_dx()

def traject():
    global drapeau_t
    if drapeau_t==0:
        drapeau_t=1

def calc_dx():
    "Calcul du mouvement : 2 ème loi de Newton"
    global x1, y1, x2,y2,l1,l2,l0,seuil,k,g,vx,vy,delta_t,masse,drapeau,alpha_anc,drapeau_p,drapeau_k,d_anc,\
    drapeau_t, trajectoire, n_traj,nb_pts, x_anc,y_anc,k1,k2,drapeau_pp,p,list_p,temps
    temps=temps+delta_t
    d=sqrt((x1-x2)**2+(y1-y2)**2)
    if d<=d_anc and drapeau_k==1:
        drapeau_k=0
        d_max=d_anc
    if d>=d_anc and drapeau_k==0:
        drapeau_k=1
        d_min=d_anc
    d_anc=d

    if d<seuil:
        d=seuil
    l1=d-l2
    sinalpha=(x1-x2)/d  # Angle alpha mesuré depuis la verticale descendant, sens trigonométrique
    cosalpha=(y1-y2)/d


    # ##############    Calcul de la force appliquée   ###############
    Fx=-k1*(l1-l0)*sinalpha
    Fy=-k2*(l1-l0)*cosalpha+masse*g
    #               ###############################

    ax=Fx/masse
    ay=Fy/masse
    vx=vx+ax*delta_t
    vy=vy+ay*delta_t
    x1=x1+vx*delta_t
    y1=y1+vy*delta_t
    if cosalpha>=0:
       alpha1=asin(sinalpha)*180/pi
    else:
        if sinalpha>=0:
           alpha1=180-(asin(sinalpha)*180/pi)
        else:
            alpha1=-180-(asin(sinalpha)*180/pi)
    if alpha1<=alpha_anc and drapeau_p==1:
        drapeau_p=0
        alpha_max=alpha_anc
    #    chaine5.configure(text='Alpha max = '+str(int(1000*alpha_max)/1000)+' °',fg='dark green', font="-size 10")
    #    chaine5.grid(row=9,column=1,columnspan=5)

    if alpha1>=alpha_anc and drapeau_p==0:
        drapeau_p=1
        alpha_min=alpha_anc
     #   chaine6.configure(text='Alpha min = '+str(int(1000*alpha_min)/1000)+' °',fg='dark green', font="-size 10")
      #  chaine6.grid(row=10,column=1,columnspan=5)

    alpha_anc=alpha1
    can1.coords(oval1, int(ech_px*x1)-5, int(ech_px*y1)-5, int(ech_px*x1)+5, int(ech_px*y1)+5)
   # can1.coords(ligne1,int(ech_px*x2),int(ech_px*y2),int(ech_px*x1),int(ech_px*y1))
    nb_pts=nb_pts+1
    if drapeau_t == 1:
        if nb_pts%10==0:
            can1.create_line(int(ech_px*x_anc),int(ech_px*y_anc),int(ech_px*x1),int(ech_px*y1),fill='blue')
            x_anc=x1
            y_anc=y1
        if nb_pts%nb_sauts==0:
            p=Point((x1,y1),'red')
            p.trace()
            list_p.append(p)
            list_fx.append(Fx)
            list_fy.append(Fy)
            chaine7.configure(text="Instant t = "+str(int(temps*1000000)/1000000)+' s = '+fonc_temps(temps), font="-size 10")
    if drapeau>0:
        fen1.after(10,calc_dx)

def pointeur(event):
    "sélection d un point ou d un vecteur avec la souris"
    "Action sur un Clic-Gauche de souris"
    global psel, drapeau_sel_pt,drapeau_sel_vect,vsel,drapeau_sel_pt_ext
    pos_x=event.x
    pos_y=event.y
    if drapeau_sel_pt==1:
        psel.change_coul('red',1)
        drapeau_sel_pt=0
    if drapeau_sel_pt_ext==1:   # extremite de vecteur
        drapeau_sel_pt_ext=0
        psel.detruit()
    for p in list_p:
        # on cherche un point
        d=dist((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
        if d<delta_pt:
            psel=p
            drapeau_sel_pt=1
            break
    if drapeau_sel_pt==1:
        psel.change_coul('dark green',2)
        chaine1.configure(text='Point sélectionné x = '+str(int(1000000*psel.x)/1000000)+' m, y = '+str(int(1000000*psel.y)/1000000)+' m', font="-size 10")
        ind_pt=list_p.index(psel)
        temps_sel=ind_pt*delta_t*nb_sauts
        chaine8.configure(text="Point sélectionné : instant t = "+str(int(temps_sel*1000000)/1000000)+' s = '+fonc_temps(temps_sel), font="-size 10")
        if drapeau_sel_vect==1:
            drapeau_sel_vect=0
            vsel.desel()

    else:
        # on cherche un vecteur
        if drapeau_sel_vect==1:
            drapeau_sel_vect=0
            vsel.desel()

        for v in list_v:
            det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
            (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])         # déterminant pour tester l'alignement
            d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1])) # P appartient au segmnt ?
            d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
            d3=v.d*ech_px
            if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
            d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                vsel=v
                drapeau_sel_vect=1
                break
        if drapeau_sel_vect==1:
            vsel.selvect()
            if vsel.coul=='magenta':
                type_v=' Déplacement '
                unite=' m '
                valeur=vsel.d
                valeur_x=vsel.x
                valeur_y=vsel.y
            elif vsel.coul==vit_coul:
                type_v=' Vitesse '
                unite=' m.s-1 '
               # nbv=int(entree1.get())
              #  nbv=nb_pas_vit_1.get()
              #  print("nb_v = ",nbv)
              #  valeur=vsel.d/(conv_vit*nbv*nb_sauts*delta_t)
                valeur=vsel.d/(conv_vit*nb_sauts*delta_t)
                valeur_x=vsel.x/(conv_vit*nb_sauts*delta_t)
                valeur_y=vsel.y/(conv_vit*nb_sauts*delta_t)
            elif vsel.coul==force_coul:
                type_v=' Force '
                unite=' N '
                valeur=vsel.d/conv_f
                valeur_x=vsel.x/conv_f
                valeur_y=vsel.y/conv_f
            elif vsel.coul==accel_coul:
                type_v=' Accélération '
                unite=' m.s-2 '
               # nbv=int(entree1.get())
               # nbv=nb_pas_vit_1.get()
               # nba=int(entree2.get())
               # print("nb_acc = ",nba)
                # valeur=vsel.d/(conv_vit*nbv*nb_sauts*delta_t)/(conv_accel*nba*nb_sauts*delta_t)
                valeur=vsel.d/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                valeur_x=vsel.x/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                valeur_y=vsel.y/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)

            chaine2.configure(text='Vecteur '+type_v+' = '+str(int(1000000*valeur)/1000000)+unite, font="-size 10")
            chaine3.configure(text=type_v+'x = '+str(int(1000000*valeur_x)/1000000)+unite+type_v+'y = '+str(int(1000000*valeur_y)/1000000)+unite, font="-size 10")

def shift_pointeur(event):
    "Action sur un Majuscule-Clic-Gauche de souris"
    global psel, drapeau_sel_pt,list_v,sel_vect,list_pv
    pos_x=event.x
    pos_y=event.y
    drapeau_sel_pt2=0
    if drapeau_sel_pt==1:
        for p in list_p:
            d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
            if d<delta_pt2:
                psel2=p
                drapeau_sel_pt2=1
                break
    if drapeau_sel_pt2==1 and psel2 != psel:
        # on a 2 points sélectionnés
        u=Vecteur((psel.x,psel.y),(psel2.x,psel2.y),'magenta',15)
        u.trace(u.coul,1)
        list_v.append(u)
        list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
    if drapeau_sel_vect==1:
        for p in list_p:
            d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
            if d<delta_pt2:
                u=Vecteur((p.x,p.y),(p.x+vsel.x,p.y+vsel.y),vsel.coul,15)
                u.trace(u.coul,1)
                list_v.append(u)
                list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                break
        for p in list_pv:
            d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
            if d<delta_pt2:
                u=Vecteur((p.x,p.y),(p.x+vsel.x,p.y+vsel.y),vsel.coul,15)
                u.trace(u.coul,1)
                list_v.append(u)
                list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                break
        drapeau_sel_vect2=0
        for v in list_v:
            det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
            (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])
            # print("det = ",det)
            d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1]))
            d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
            d3=v.d*ech_px
            if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
            d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                vsel2=v
                drapeau_sel_vect2=1
                break
        if drapeau_sel_vect2==1:
            # vsel.selvect()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel2.P2[0],vsel2.P2[1]),vsel2.coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur

def ctrl_clic_droit(event):
    "Selection specifique d'une extremite de vecteur"
    global drapeau_sel_pt_ext, drapeau_sel_pt, psel
    pos_x=event.x
    pos_y=event.y
    if drapeau_sel_pt_ext==1:
        drapeau_sel_pt_ext=0
        psel.detruit()
    if drapeau_sel_pt==1:
        drapeau_sel_pt=0
        psel.change_coul('red',1)
    for p in list_pv:
            d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
            if d<delta_pt2:
                psel=p
                drapeau_sel_pt_ext=1
                break
    if drapeau_sel_pt_ext==1:
        psel.change_coul('dark green',2)

def man_vecteur(event):
    "Construction manuelle d'un vecteur par ctrl-shift-button-1"
    "Projection sur un vecteur"
    global list_p, list_v, list_pv
    if drapeau_sel_pt==1 or drapeau_sel_pt_ext==1:
        if drapeau_man==0:
            fen1.iconify()
            reponse=input("Pour placer un point : entrez l'abscisse x du point en mètre (origine en haut à gauche)")
            x_pos=float(reponse)
            reponse=input("Pour placer un point : entrez l'ordonnée y du point en mètre (origine en haut à gauche)")
            fen1.deiconify()
            y_pos=float(reponse)
            p=Point((x_pos,y_pos),'red')
            p.trace()
            list_p.append(p)
        elif drapeau_man==1:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur déplacement depuis le point sélectionné: entrez sa composante x en mètre")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur déplacement depuis le point sélectionné: entrez sa composante y en mètre")
            y_pos=float(reponse)
            fen1.deiconify()
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos,psel.y+y_pos),'magenta',15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==2:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur vitesse depuis le point sélectionné: entrez sa composante Vx en mètre par seconde")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur vitesse depuis le point sélectionné: entrez sa composante Vy en mètre par seconde")
            fen1.deiconify()
            y_pos=float(reponse)
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos*conv_vit*nb_sauts*delta_t,psel.y+y_pos*conv_vit*nb_sauts*delta_t),vit_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==3:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur accélération depuis le point sélectionné: entrez sa composante ax en mètre par seconde au carré")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur accélération depuis le point sélectionné: entrez sa composante ay en mètre par seconde au carré")
            fen1.deiconify()
            y_pos=float(reponse)
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t,psel.y+y_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t),accel_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        else:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur force depuis le point sélectionné: entrez sa composante Fx en newton")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur force depuis le point sélectionné: entrez sa composante Fy en newton")
            fen1.deiconify()
            y_pos=float(reponse)
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos*conv_f,psel.y+y_pos*conv_f),force_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
    if drapeau_sel_vect==1:
        drapeau_sel_vect2=0
        pos_x=event.x
        pos_y=event.y
        for v in list_v:
            det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
            (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])
            # print("det = ",det)
            d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1]))
            d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
            d3=v.d*ech_px
            if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
            d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                vsel2=v
                drapeau_sel_vect2=1
                break
        if drapeau_sel_vect2==1:
            # vsel.selvect()
            Ftx=(vsel2.x*vsel.x+vsel2.y*vsel.y)*vsel.x/vsel.d/vsel.d
            Fty=(vsel2.x*vsel.x+vsel2.y*vsel.y)*vsel.y/vsel.d/vsel.d   # produit scalaire pour projeter sur vsel

            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+Ftx,vsel.P1[1]+Fty),vsel2.coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur

def man_vecteur_2(event):
    "Construction d'un point ou d'un vecteur colineaire a un autre vecteur, par CTRL-SHIFT-BOUTON-3"
    global list_p,list_v,list_pv
    if drapeau_sel_vect==1:
        if drapeau_man==0:
            fen1.iconify()
            reponse=input("Pour placer un point : entrez la distance en mètre depuis l'origine du vecteur sélectionné")
            x_pos=float(reponse)
            fen1.deiconify()
            p=Point((vsel.P1[0]+vsel.x/vsel.d*x_pos,vsel.P1[1]+vsel.y/vsel.d*x_pos),'red')
            p.trace()
            list_p.append(p)
        elif drapeau_man==1:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur déplacement colinéaire au vecteur sélectionné : entrez sa valeur en mètre")
            x_pos=float(reponse)
            fen1.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*vsel.x/vsel.d,vsel.P1[1]+x_pos*vsel.y/vsel.d),'magenta',15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==2:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur vitesse colinéaire au vecteur sélectionné: entrez sa valeur V en mètre par seconde")
            x_pos=float(reponse)
            fen1.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*conv_vit*nb_sauts*delta_t*vsel.x/vsel.d,vsel.P1[1]+x_pos*conv_vit*nb_sauts*delta_t*vsel.y/vsel.d),vit_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==3:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur accélération colinéaire au vecteur sélectionné: entrez sa valeur a en mètre par seconde au carré")
            x_pos=float(reponse)
            fen1.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t*vsel.x/vsel.d,\
            vsel.P1[1]+x_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t*vsel.y/vsel.d),accel_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        else:
            fen1.iconify()
            reponse=input("Pour tracer un vecteur force colinéaire au vecteur sélectionné: entrez sa valeur F en newton")
            x_pos=float(reponse)
            fen1.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*conv_f*vsel.x/vsel.d,vsel.P1[1]+x_pos*conv_f*vsel.y/vsel.d),force_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur


def conv_vitesse():
    "Mise à l'échelle d'une vitesse (bouton)"
    global vsel, list_v, list_pv, drapeau_sel_vect
    if drapeau_sel_vect==1:
        if vsel.coul=='magenta':
            nbv=int(entree1.get())
            vsel.detruit()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+vsel.x*conv_vit/nbv,vsel.P1[1]+vsel.y*conv_vit/nbv),vit_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            a=list_v.index(vsel)
            list_v[a]=Vecteur((-1,-1),(-1,-1))
            drapeau_sel_vect=0


def conv_acceleration():
    "Mise à l'échelle d'une accélération (bouton)"
    global vsel, list_v, list_pv, drapeau_sel_vect
    if drapeau_sel_vect==1:
        if vsel.coul==vit_coul:
            nba=int(entree2.get())
            vsel.detruit()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+vsel.x*conv_accel/nba,vsel.P1[1]+vsel.y*conv_accel/nba),accel_coul,15)
            u.trace(u.coul,1)
            list_v.append(u)
            list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            a=list_v.index(vsel)
            list_v[a]=Vecteur((-1,-1),(-1,-1))
            drapeau_sel_vect=0


def suppr_vect(event):
    "Suppression du vecteur sélectionné par Majuscule-Clic-Droit"
    global vsel, list_v,drapeau_sel_vect
    if drapeau_sel_vect==1:
        vsel.detruit()
        a=list_v.index(vsel)
        list_v[a]=Vecteur((-1,-1),(-1,-1))
        drapeau_sel_vect=0

def aff_force(event):
    "Affichage du vecteur force par Controle-Clic sur un point sélectionné"
    if drapeau_sel_pt:
        a=list_p.index(psel)
        u=Vecteur((psel.x,psel.y),(psel.x+list_fx[a-1]*conv_f,psel.y+list_fy[a-1]*conv_f),force_coul,15)
        u.trace(u.coul,1)
        list_v.append(u)
        list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur



def moins_vect(event):
    "Opposé du vecteur sélectionné par Clic-Droit"
    global vsel
    if drapeau_sel_vect==1:
        u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]-vsel.x,vsel.P1[1]-vsel.y),vsel.coul,15)
        u.trace(vsel.coul,1)
        list_v.append(u)
        list_pv.append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur

def choix_vecteur():
    "Action des boutons radio pour la sélection d'un vecteur"
    global l_coul, drapeau_man
    numero_vecteur=type_vecteur.get()
    if numero_vecteur==0:
        l_coul=['magenta',vit_coul,accel_coul,force_coul]
        drapeau_man=0
    elif numero_vecteur==1:
        l_coul=['magenta']
        drapeau_man=1
    elif numero_vecteur==2:
        l_coul=[vit_coul]
        drapeau_man=2
    elif numero_vecteur==3:
        l_coul=[accel_coul]
        drapeau_man=3
    else:
        l_coul=[force_coul]
        drapeau_man=4


def dist(A,B):
    "Calcul de la distance entre 2 points"
    return sqrt((A[0]-B[0])**2+(A[1]-B[1])**2)

def dist2(A,B):
    "Calcul de la distance au carré"
    return (A[0]-B[0])**2+(A[1]-B[1])**2

def fonc_temps(t):
    nb_an=int(t/31557600)
    nb_jour=int((t-nb_an*31557600)/86400)
    nb_heure=int((t-nb_an*31557600-nb_jour*86400)/3600)
    nb_minute=int((t-nb_an*31557600-nb_jour*86400-nb_heure*3600)/60)
    nb_seconde=int((t-nb_an*31557600-nb_jour*86400-nb_heure*3600-nb_minute*60)*1000000)/1000000
    return str(nb_an)+" ans "+str(nb_jour)+" jours "+str(nb_heure)+" heures "+str(nb_minute)+" min "+str(nb_seconde)+" s"

# Programme principal

fen1=Tk()

# variables globales

# Données à modifier :  ############################################

k1=29.43          # raideur du ressort en N.m-1 en x
k2=29.43          # idem en y
L=0.8                # distance initiale par rapport au centre
l2=0.09          # longueur de fil supplémentaire
l0=0.0          # longueur à vide du ressort
angle=2   # angle initial en degrés par rapport à la verticale
vr0=0               # vitesse initiale radiale
val0=0              # vitesse initiale orthoradiale
masse=0.3       # masse en kg
g=9.81        # intensité de la pesanteur
deltaxx=0.19
xeq=masse*g/k1+l2
L=xeq+deltaxx         # depart a etirement constant

# #################################################################

force_coul='#924e25'  # force
vit_coul='#d36069'   # vitesse
accel_coul='#39dbf4'  # accélération
l_coul=['magenta',vit_coul,accel_coul,force_coul]
nb_sauts=40 #  Nombre de pas de tempsentre 2 croix rouges de trajectoire
conv_f=0.05 #  Echelle géométrique pour les vecteurs force en pixel par newton
list_fx=[]
list_fy=[]
conv_vit=2.7 # Echelle géométrique pour les vecteurs vitesse en pixel par mètre par seconde : 2.0
conv_accel=3.0 # Echelle géométrique pour les vecteurs accélération en pixel/(m.s-2)  1.2
drapeau_sel_vect=0
vsel=None
drapeau_man=0   # pour la création d'un point ou d'un vecteur par ses coordonnées
drapeau_sel_pt=0  # 1 si un point est sélectionné
drapeau_sel_pt_ext=0  # 1 si un point extremite de vecteur est sélectionné

psel=Point((0,0))   # point selectionné
delta_pt=4  # distance pour sélecionner un point en pixel
delta_pt2=delta_pt**2
delta_vect_ext=12  # distance des extrémités pour ne pas sélectionner un vecteur
delta_vect_ext2=delta_vect_ext**2
ech_px=400   #echelle : nombre de pixels pour un mètre
delta_vect=20  # pour tester la nullité du déterminant pour sélectionner un vecteur
delta_vect2=delta_vect*delta_vect  # pour le déterminant
delta_t=0.001    # pas de temps pour le calcul

duree=10000    # animation
seuil=1e-10


drapeau=0
drapeau_p=0
drapeau_k=0
drapeau_t=0
drapeau_pp=0
nb_pts=0
liste_al_max=[]
liste_al_min=[]
dim_x=800       # dimensions de la fenêtre
dim_y=800
x2 = dim_x/2/ech_px  # point d'attache du fil et du ressort au centre
y2 = (dim_y-600)/2/ech_px
angle=angle*pi/180  # converti en radians
#x0=x2+0.2      # position initiale
#y0=y2+0.75
x0=x2+L*sin(angle)  # position initiale
y0=y2+L*cos(angle)
v0x=vr0*sin(angle)+val0*cos(angle)      # vitesse initiale
v0y=vr0*cos(angle)-val0*sin(angle)
rac2=sqrt(2)/2
x1=x0
y1=y0
x_anc=x1
y_anc=y1
vx=v0x
vy=v0y
d0=sqrt((x0-x2)**2+(y0-y2)**2)
cosalpha0=(y0-y2)/d0
sinalpha0=(x0-x2)/d0
alpha_anc=0
d_anc=0
lpointe=5  # nombre de pixels de la pointe d'un vecteur
trajectoire=[]
temps=0
can1=Canvas(fen1,bg='dark grey',height=dim_y,width=dim_x)


#can1.pack(side=LEFT, padx=5,pady=5)
can1.grid(column=0,row=0,rowspan=15)
oval1=can1.create_oval(int(ech_px*x1)-5,int(ech_px*y1)-5,int(ech_px*x1)+5, int(ech_px*y1)+5, width=2, fill='red')
#oval2=can1.create_oval(souris_x-20,souris_y-20,souris_x+20,souris_y+20,width=2)
#ligne1=can1.create_line(int(ech_px*x2),int(ech_px*y2),int(ech_px*x1),int(ech_px*y1),width=2)
#ligne2=can1.create_line(souris_x-30, souris_y,souris_x+30,souris_y,width=2)
bou1=Button(fen1,text='Quitter', width=8,command=fen1.quit)
#bou1.pack(side=BOTTOM)
bou1.grid(row=11,column=4)
bou2=Button(fen1, text='Démarrer',width=8,command=start_it)
bou2.grid(row=0, column =2)
bou3=Button(fen1,text='Arrêter',width=8,command=stop_it)
bou3.grid(row=0, column=3)
bou4=Button(fen1, text='Trajectoire',width=8,command=traject)
bou4.grid(row=0,column=1)
p=Point((x2,y2))
p.trace()
list_p=[]
list_v=[]
list_pv=[]  # points extémités de vecteurs
list_p.append(p)

bou5=Button(fen1, text='Eff Points',width=8,command=detruit_dernier)
bou5.grid(row=11,column=1)
bou6=Button(fen1, text='Visu Points',width=8,command=visualisation_points)
bou6.grid(row=11,column=2)
bou7=Button(fen1, text='Déplacement --> Vitesse',width=18,command=conv_vitesse)
bou7.grid(row=1, column=1)
bou8=Button(fen1, text='Vitesse --> Accélération',width=18,command=conv_acceleration)
bou8.grid(row=1, column=3)
chaine4=Label(fen1)
chaine5=Label(fen1)
chaine4.grid(row=3,column=1)
chaine4.configure(text="Nb pas vitesse", font="-size 10")
chaine5.grid(row=3,column=3)
chaine5.configure(text="Nb pas accélération", font="-size 10")
#nb_pas_vit_1=IntVar()
#nb_pas_acc_1=IntVar()
#nb_pas_vit_1.set(2)
#nb_pas_vit_1.set(2)
#entree1=Entry(fen1, width=5,textvariable=nb_pas_vit_1)
entree1=Entry(fen1,width=5)
entree1.grid(row=2,column=1)
entree2=Entry(fen1,width=5)
entree2.grid(row=2,column=3)
entree1.insert(0,'2')
entree2.insert(0,'2')

type_vecteur=IntVar()
type_vecteur.set(0)
choix_tout=Radiobutton(fen1,text='Tous',variable=type_vecteur,value=0,command=choix_vecteur)
choix_depla=Radiobutton(fen1,text='Déplacement',variable=type_vecteur,value=1,command=choix_vecteur)
choix_vites=Radiobutton(fen1,text='Vitesse',variable=type_vecteur,value=2,command=choix_vecteur)
choix_accel=Radiobutton(fen1,text='Accélération',variable=type_vecteur,value=3,command=choix_vecteur)
choix_force=Radiobutton(fen1,text='Force',variable=type_vecteur,value=4,command=choix_vecteur)
choix_tout.grid(row=4,column=1)
choix_depla.grid(row=4,column=2)
choix_vites.grid(row=4,column=3)
choix_accel.grid(row=4,column=4)
choix_force.grid(row=4,column=5)

can1.bind("<Button-1>",pointeur)
can1.bind("<Shift-Button-1>",shift_pointeur)
can1.bind('<Button-3>',moins_vect)
can1.bind('<Shift-Button-3>',suppr_vect)
can1.bind('<Control-Button-1>',aff_force)
can1.bind('<Control-Button-3>',ctrl_clic_droit)
can1.bind('<Control-Shift-Button-1>',man_vecteur)
can1.bind('<Control-Shift-Button-3>',man_vecteur_2)

chaine1=Label(fen1)
chaine2=Label(fen1)
#chaine1.pack()
chaine1.grid(row=8,column=1,columnspan=5)
chaine2.grid(row=9,column=1,columnspan=5)
chaine3=Label(fen1)
chaine3.grid(row=10,column=1,columnspan=5)
#chaine3.configure(text='Masse = '+str(int(10000*masse)/10000)+' kg, k = '+str(int(10000*k)/10000)+' N.m-1, L = '+str(int(10000*(l0+l2))/10000)+' m',fg='red', font="-size 10")
#chaine3.pack()
chaine6=Label(fen1)
chaine6.grid(row=5,column=1,columnspan=5)
chaine6.configure(text='----------------- choix de sélection du vecteur -----------------',font="-size 10")
chaine7=Label(fen1)
chaine7.grid(row=6,column=1,columnspan=5)
chaine7.configure(text="Instant courant t = "+str(temps)+' s = '+fonc_temps(temps), font="-size 10")
chaine8=Label(fen1)
chaine8.configure(text="Point sélectionné : instant t = "+str(temps)+' s = '+fonc_temps(temps), font="-size 10")
chaine8.grid(row=7,column=1,columnspan=5)

if cosalpha0>=0:
    alpha0=asin(sinalpha0)*180/pi
else:
    alpha0=180-(asin(sinalpha0)*180/pi)
vr=v0y*cosalpha0+v0x*sinalpha0
val=v0x*cosalpha0-v0y*sinalpha0
#chaine4.configure(text='Alpha 0 = '+str(int(10000*alpha0)/10000)+' °, d = '+str(int(10000*d0)/10000)+' m, Vradial = '+\
#str(int(10000*vr)/10000)+' m/s, Vortho = '+str(int(10000*val)/10000)+' m/s',fg='dark green', font="-size 10")
#chaine4.grid(row=6,column=1,columnspan=5)
#fen1.after(duree,soustraction_score)

fen1.mainloop()
fen1.destroy()