﻿# micromeca_01_01.py     : introduction à la simulation en mécanique  (MarcusAxisym 10/05/2021)
# calcul d'une trajectoire par la méthode d'Euler.
# voir Mecalab pour un script plus évolué

# x horizontal vers la droite
# y vertical vers le bas
# origine en haut à gauche

# micromeca_03_03.py    :  Ressort en x et y différents


from tkinter import *
from math import *

position_x_initiale=0.2                         # position initiale en mètres
position_y_initiale=1.0
vitesse_x_initiale=1.2                        # vitesse initiale en mètres par seconde
vitesse_y_initiale=-3.0
masse=2.0                        # masse en kilogramme
g=9.81                         # intensité de la pesanteur en newton par kilogramme
raideur_ressort_x=100             # raideur du ressort en N.m^-1
raideur_ressort_y=150


instant_final_calcul=4.99999999        # en seconde
delta_t=0.01                   # pas de temps pour le calcul en seconde
echelle=500                   # nombre de pixels pour représenter 1 mètre dans la réalité 500
dim_x=800                     # dimensions de la fenêtre en pixels
dim_y=800
delai=5000                   # durée pour l'animation
t_anim=int(delai*delta_t)
if t_anim<1 :
    t_anim=1
position_x_centre=dim_x/echelle/2
position_y_centre=dim_y/echelle/2
x_ancien = position_x_initiale
y_ancien = position_y_initiale
vitesse_x_ancien = vitesse_x_initiale
vitesse_y_ancien = vitesse_y_initiale

# initialisation de variables
x_nouveau=0
y_nouveau=0
vitesse_x_nouveau=0
vitesse_y_nouveau=0


drapeau=0                      # interrupteur pour le calcul
instant=0                      # instant où le calcul est effectué

def start_it():    # fonction appelée par le bouton "Démarrer"
    global drapeau
    if drapeau==0:
        drapeau=1
    calc_dx()

def stop_it():     # fonction appelée par le bouton "Arrêter"
    global drapeau
    drapeau=0
    print("Instant final = ",str(instant)," seconde")

def force_x():
    global x_ancien, y_ancien, vitesse_x_ancien, vitesse_y_ancien, masse, g, instant, position_x_centre
    force_xx=-raideur_ressort_x*(x_ancien-position_x_centre)
    return force_xx                      # composante x de la force en newton

def force_y():
    global x_ancien, y_ancien, vitesse_x_ancien, vitesse_y_ancien, masse,g, instant, position_y_centre
    force_yy=-raideur_ressort_y*(y_ancien-position_y_centre)
    return force_yy                      # composante y de la force en newton

def calc_dx():
    "Calcul de la trajectoire au pas de temps suivant : 2 ème loi de Newton   Méthode d'Euler"
    global vitesse_x_ancien, vitesse_y_ancien, \
    vitesse_x_nouveau, vitesse_y_nouveau,x_ancien,y_ancien,x_nouveau,y_nouveau, \
    instant, delta_t, echelle, drapeau, masse

    instant=instant+delta_t                # nouvel instant pour le calcul

    vitesse_x_nouveau = vitesse_x_ancien + force_x() * delta_t / masse   # appel de la fonction force_x() pour la 2ème loi de Newton
    vitesse_y_nouveau = vitesse_y_ancien + force_y() * delta_t / masse

    x_nouveau = x_ancien + vitesse_x_nouveau * delta_t     # relation entre la vitesse et les positions initiale et finale
    y_nouveau = y_ancien + vitesse_y_nouveau * delta_t

    can1.create_line(int(echelle*x_ancien),int(echelle*y_ancien),int(echelle*x_nouveau),int(echelle*y_nouveau),fill='blue') # tracé de la trajectoire entre M1 et M2
    can1.coords(oval1, int(echelle*x_nouveau)-5, int(echelle*y_nouveau)-5, int(echelle*x_nouveau)+5, int(echelle*y_nouveau)+5) # tracé de M2 en rouge
    x_ancien = x_nouveau
    y_ancien = y_nouveau
    vitesse_x_ancien = vitesse_x_nouveau
    vitesse_y_ancien = vitesse_y_nouveau
    chaine1.configure(text='Point x = '+str(int(10000000*x_nouveau)/10000000)+' m, y = '+str(int(10000000*y_nouveau)/10000000)+' m', font="-size 10") # affichage des valeurs
    chaine2.configure(text="Instant t = "+str(int(instant*10000000)/10000000)+' s', font="-size 10")

    if (instant < instant_final_calcul)and(drapeau==1):   # 2 possibilités pour arrêter le calcul : instant final ou bouton "Arrêter"
        fen1.after(t_anim,calc_dx)  #50         boucle pour le calcul au pas de temps suivant (attente 50 ms)

def quadrillage():
    global dim_x, dim_y
    pasx=0.1    # pas du cadrillage en mètre
    nx=int(dim_x/(echelle*pasx))
    ny=int(dim_y/(echelle*pasx))
    couleur='#39dbf4'
    for i in range (nx):
        can1.create_line(i*echelle*pasx,0,i*echelle*pasx,dim_y,fill=couleur)
    for i in range (ny):
        can1.create_line(0,i*echelle*pasx,dim_x,i*echelle*pasx,fill=couleur)

# fin du calcul de la trajectoire au pas de temps suivant

fen1=Tk()

can1=Canvas(fen1,bg='dark grey',height=dim_y,width=dim_x)
can1.grid(column=0,row=0,rowspan=15)
bou2=Button(fen1, text='Démarrer',width=15,command=start_it)
bou2.grid(row=0, column =1)
bou3=Button(fen1,text='Arrêter',width=15,command=stop_it)
bou3.grid(row=1, column=1)
bou1=Button(fen1,text='Quitter', width=15,command=fen1.quit)
bou1.grid(row=2,column=1)
bou4=Button(fen1,text='Quadrillage', width=15,command=quadrillage)
bou4.grid(row=3,column=1)
oval1=can1.create_oval(int(echelle*position_x_initiale)-5,int(echelle*position_y_initiale)-5, \
int(echelle*position_x_initiale)+5, int(echelle*position_y_initiale)+5, width=2, fill='red')
chaine1=Label(fen1)
chaine1.configure(text='Point x = '+str(int(10000000*position_x_initiale)/10000000)+' m, y = '+str(int(10000000*position_y_initiale)/10000000)+' m', font="-size 10")
chaine1.grid(row=4,column=1,columnspan=3)
chaine2=Label(fen1)
chaine2.configure(text="Instant t = "+str(instant)+' s', font="-size 10")
chaine2.grid(row=7,column=1,columnspan=3)
fen1.mainloop()
fen1.destroy()