﻿# mecalab_08.py : 3 courbes simulées + 3 courbes expérimentales + gestion des écrans par ascenseurs.
# pointage_07 : 2courbes experimentales + centre de gravite. 2021_02_19   2021_03_09 : 3 courbes théoriques en plus des 3 courbes expérimentales
# 2021/02/21 : fichier de sauvegarde
# chute libre : affichage des composantes des vecteurs. Conditions initiales en polaires.
# mecalab_05 : on peut tracer un vecteur arbitraire. Projection sur un vecteur CTRL - Shift -Clic - Droit

from tkinter import *
from math import *
import os.path

class Point(object):
    "Point geométrique"
    delta_x=5   # demi-dimension de la croix pour le point
    def __init__(self,coordonnees,couleur='black',epaiss=1):
        "création d'un point"
        self.x=coordonnees[0]
        self.y=coordonnees[1]
        self.coul=couleur
        self.ep=epaiss
        self.lx=None
        self.ly=None

    def trace(self):
        "tracé d'un point"
        self.ly=can1.create_line(int(ech_px*self.x),int(ech_px*self.y)-Point.delta_x,int(ech_px*self.x),int(ech_px*self.y)+Point.delta_x,fill=self.coul,width=self.ep)
        self.lx=can1.create_line(int(ech_px*self.x)-Point.delta_x,int(ech_px*self.y),int(ech_px*self.x)+Point.delta_x,int(ech_px*self.y),fill=self.coul,width=self.ep)

    def detruit(self):
        "détruit le tracé du point"
        can1.delete(self.lx)
        can1.delete(self.ly)

    def change_coul(self,couleur,epaiss):
        self.coul=couleur
        self.ep=epaiss
        self.detruit()
        self.trace()


def detruit_dernier():
    global list_p
    for p in list_p:
        p.detruit()
def visualisation_points():
    global list_p
    for p in list_p:
        p.trace()

class Vecteur(object):
    "vecteur"
    def __init__(self,A=(0,0),B=(0,0),couleur='black',lpointe=5):
        "création d'un vecteur"
        self.x=B[0]-A[0]
        self.y=B[1]-A[1]
        self.P1=A
        self.P2=B
        self.coul=couleur
        self.lp=lpointe
        self.d=sqrt((self.x)**2+(self.y)**2)
        if self.d<1e-20:
            self.d=1e-20
        self.cosalpha=self.y/self.d
        self.sinalpha=self.x/self.d
        self.cosalpha2=rac2*self.cosalpha+rac2*self.sinalpha
        self.sinalpha2=rac2*self.sinalpha-rac2*self.cosalpha
        self.cosalpha3=rac2*self.cosalpha-rac2*self.sinalpha
        self.sinalpha3=rac2*self.sinalpha+rac2*self.cosalpha
        self.pte1x=self.lp*self.cosalpha2
        self.pte1y=self.lp*self.sinalpha2
        self.pte2x=self.lp*self.cosalpha3
        self.pte2y=self.lp*self.sinalpha3

    def trace(self,couleur,epaiss):
        "tracé d'un vecteur"
        self.lvect=can1.create_line(int(ech_px*self.P1[0]),int(ech_px*self.P1[1]),int(ech_px*self.P2[0]),int(ech_px*self.P2[1]),fill=couleur,width=epaiss)
        self.lpte1=can1.create_line(int(ech_px*self.P2[0]),int(ech_px*self.P2[1]),int(ech_px*self.P2[0]-self.pte1x),int(ech_px*self.P2[1]+self.pte1y),fill=couleur,width=epaiss)
        self.lpte2=can1.create_line(int(ech_px*self.P2[0]),int(ech_px*self.P2[1]),int(ech_px*self.P2[0]+self.pte2x),int(ech_px*self.P2[1]-self.pte2y),fill=couleur,width=epaiss)

    def desel(self):
        "déselection d'un vecteur"
        self.detruit()
        Vecteur.trace(self,self.coul,1)

    def selvect(self):
        "sélection d'un vecteur"
        self.detruit()
        Vecteur.trace(self,'dark green',2)

    def detruit(self):
        "effacement d'un vecteur"
        can1.delete(self.lvect)
        can1.delete(self.lpte1)
        can1.delete(self.lpte2)


def stop_it():
    global drapeau
    drapeau=0

def start_it():
    global drapeau
    if drapeau==0:
        drapeau=1
        calc_dx()

def traject():
    global drapeau_t
    if drapeau_t==0:
        drapeau_t=1

def calc_dx():
    "Calcul du mouvement : 2 ème loi de Newton"
    global x1, y1,z1,x2,y2,z2,l1,l2,l0,seuil,k,g,vx,vy,vz,delta_t,masse,drapeau,alpha_anc,drapeau_p,drapeau_k,d_anc,\
    drapeau_t, trajectoire, n_traj,nb_pts, x_anc,y_anc,z_anc,k1,k2,drapeau_pp,p,list_p,temps
    rk_th=temps   # pour Runge-Kutta
# appel runge_kutta()

    rk_x[0]=x1
    rk_x[1]=y1
    rk_x[2]=z1
    rk_v[0]=vx
    rk_v[1]=vy
    rk_v[2]=vz

    for itsim in range(nb_cb_sim):
        runge_kutta(itsim,rk_x,rk_v,rk_th)
    x1=rk_x[0]
    y1=rk_x[1]
    z1=rk_x[2]
    for itsim in range(nb_cb_tra_sim):
        if itsim <2 :
            vx[itsim]=rk_v[0][itsim]
            vy[itsim]=rk_v[1][itsim]
            vz[itsim]=rk_v[2][itsim]
        elif (itsim==2 and nb_cb_tra_sim==3):
            x1[2]=(x1[0]*masse[0]+x1[1]*masse[1])/(masse[0]+masse[1])
            y1[2]=(y1[0]*masse[0]+y1[1]*masse[1])/(masse[0]+masse[1])
            z1[2]=(z1[0]*masse[0]+z1[1]*masse[1])/(masse[0]+masse[1])
    nb_pts=nb_pts+1
    for itsim in range(nb_cb_tra_sim):
        if itsim<2:
            can1.coords(oval1[itsim], int(ech_px*x1[itsim])-5, int(ech_px*y1[itsim])-5, int(ech_px*x1[itsim])+5, int(ech_px*y1[itsim])+5)
        if drapeau_t == 1:
            if nb_pts%10==0:
                can1.create_line(int(ech_px*x_anc[itsim]),int(ech_px*y_anc[itsim]),int(ech_px*x1[itsim]),int(ech_px*y1[itsim]),fill='blue')
                x_anc[itsim]=x1[itsim]
                y_anc[itsim]=y1[itsim]
                z_anc[itsim]=z1[itsim]
            if nb_pts%nb_sauts==0:
                p=Point((x1[itsim],y1[itsim]),'red')
                p.trace()
                list_p[itsim].append(p)
                if itsim<2:
                    finter_x=force_x(itsim,rk_x[0],rk_x[1],rk_v[0],rk_v[1],rk_th)  # recalcul pour l'affichage
                    finter_y=force_y(itsim,rk_x[0],rk_x[1],rk_v[0],rk_v[1],rk_th)
                    finter_z=0
                    list_fx[itsim].append(finter_x)
                    list_fy[itsim].append(finter_y)
                    list_fz[itsim].append(finter_z)
                elif nb_cb_tra_sim==3:
                    list_fx[itsim].append(0)
                    list_fy[itsim].append(0)
                    list_fz[itsim].append(0)
            chaine7.configure(text="Instant t = "+str(int(temps*1000000)/1000000)+' s = '+fonc_temps(temps), font="-size 10")
    if drapeau>0:
        temps=temps+delta_t
        root.after(20,calc_dx)  #10

def rk_a(itsim,rki,rk_x,rk_v,rk_th):
    global Fx,Fy,Fz
    # calcul de l'accélération ax, ay et az
    global masse, g
    if rki==0:
        Fx[itsim]=force_x(itsim,rk_x[0],rk_x[1],rk_v[0],rk_v[1],rk_th)
        ax=Fx[itsim]/masse[itsim]
        return ax
    elif rki==1:
        Fy[itsim]=force_y(itsim,rk_x[0],rk_x[1],rk_v[0],rk_v[1],rk_th)
        ay=Fy[itsim]/masse[itsim]
        return ay
    elif rki==2:
        az=0
        Fz[itsim]=masse[itsim]*az
        return az


def runge_kutta(itsim,rk_x,rk_v,rk_th):
    global rk_h, rk_hh, rk_h6,dydx_x, dydx_v,dydx_dyt_x,dydx_dyt_v,dydx_dym_x,dydx_dym_v,rk_x_yt1,rk_v_yt1,rk_x_yt2,rk_v_yt2,rk_x_yt3,rk_v_yt3,\
    traj_01,xlast,ylast,zlast
    # numerical recipies p 712
    for rki in range(3):
        dydx_x[rki]=rk_v[rki][itsim]
        rk_x_yt1[rki][itsim]=rk_x[rki][itsim]+rk_hh*dydx_x[rki]
        dydx_v[rki]=rk_a(itsim,rki,rk_x,rk_v,rk_th)
        rk_v_yt1[rki][itsim]=rk_v[rki][itsim]+rk_hh*dydx_v[rki]
    for rki in range(3):
        dydx_dyt_x[rki]=rk_v_yt1[rki][itsim]
        rk_x_yt2[rki][itsim]=rk_x[rki][itsim]+rk_hh*dydx_dyt_x[rki]
        dydx_dyt_v[rki]=rk_a(itsim,rki,rk_x_yt1,rk_v_yt1,rk_th)
        rk_v_yt2[rki][itsim]=rk_v[rki][itsim]+rk_hh*dydx_dyt_v[rki]
    for rki in range(3):
        dydx_dym_x[rki]=rk_v_yt2[rki][itsim]
        rk_x_yt3[rki][itsim]=rk_x[rki][itsim]+rk_h*dydx_dym_x[rki]
        dydx_dym_v[rki]=rk_a(itsim,rki,rk_x_yt2,rk_v_yt2,rk_th)
        rk_v_yt3[rki][itsim]=rk_v[rki][itsim]+rk_h*dydx_dym_v[rki]
        dydx_dym_x[rki]+=dydx_dyt_x[rki]
        dydx_dym_v[rki]+=dydx_dyt_v[rki]
    for rki in range(3):
        dydx_dyt_x[rki]=rk_v_yt3[rki][itsim]
        rk_x[rki][itsim]=rk_x[rki][itsim]+rk_h6*(dydx_x[rki]+dydx_dyt_x[rki]+2.0*dydx_dym_x[rki])
        dydx_dyt_v[rki]=rk_a(itsim,rki,rk_x_yt3,rk_v_yt3,rk_th)
        rk_v[rki][itsim]=rk_v[rki][itsim]+rk_h6*(dydx_v[rki]+dydx_dyt_v[rki]+2.0*dydx_dym_v[rki])



def pointeur(event):
    "sélection d un point ou d un vecteur avec la souris"
    "Action sur un Clic-Gauche de souris"
    global psel, drapeau_sel_pt,drapeau_sel_vect,vsel,drapeau_sel_pt_ext,numero_trace
    pos_x=event.x
    pos_y=event.y
    if drapeau_sel_pt==1:
        psel.change_coul('red',1)
        drapeau_sel_pt=0
    if drapeau_sel_pt_ext==1:   # extremite de vecteur
        drapeau_sel_pt_ext=0
        psel.detruit()
    if len(l_coul)>1:   # tous est selectionné
        if numero_trace==0:
            for p in list_p[numero_trace_sim]:
                # on cherche un point
                d=dist((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if (d<delta_pt):  # pas le point au centre du manège
                    psel=p
                    drapeau_sel_pt=1
                    break
        else:
            for p in list_p_exp[numero_trace_exp]:
                # on cherche un point
                d=dist((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if d<delta_pt:
                    psel=p
                    drapeau_sel_pt=1
                    break

    if drapeau_sel_pt==1:
        psel.change_coul('dark green',2)
        chaine1.configure(text='Point sélectionné x = '+str(int(1000000*psel.x)/1000000)+' m, y = '+str(int(1000000*psel.y)/1000000)+' m', font="-size 10")
        if numero_trace==0:
            ind_pt=list_p[numero_trace_sim].index(psel)
            temps_sel=(ind_pt-1)*delta_t*nb_sauts
        else:
            ind_pt=list_p_exp[numero_trace_exp].index(psel)
            temps_sel=ind_pt*delta_t_exp
        chaine8.configure(text="Point sélectionné : instant t = "+str(int(temps_sel*1000000)/1000000)+' s = '+fonc_temps(temps_sel), font="-size 10")
        if drapeau_sel_vect==1:
            drapeau_sel_vect=0
            vsel.desel()

    else:
        # on cherche un vecteur
        if drapeau_sel_vect==1:
            drapeau_sel_vect=0
            vsel.desel()
        if numero_trace==0:
            for v in list_v[numero_trace_sim]:
                det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
                (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])         # déterminant pour tester l'alignement
                d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1])) # P appartient au segmnt ?
                d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
                d3=v.d*ech_px
                if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
                d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                    vsel=v
                    drapeau_sel_vect=1
                    break
        else:
            for v in list_v_exp[numero_trace_exp]:
                det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
                (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])         # déterminant pour tester l'alignement
                d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1])) # P appartient au segmnt ?
                d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
                d3=v.d*ech_px
                if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
                d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                    vsel=v
                    drapeau_sel_vect=1
                    break
        if drapeau_sel_vect==1:
            vsel.selvect()
            if vsel.coul=='magenta':
                type_v=' Déplacement '
                unite=' m '
                valeur=vsel.d
                valeur_x=vsel.x
                valeur_y=vsel.y
            elif vsel.coul==vit_coul:
                type_v=' Vitesse '
                unite=' m.s-1 '
                if numero_trace==0:
                    valeur=vsel.d/(conv_vit*nb_sauts*delta_t)
                    valeur_x=vsel.x/(conv_vit*nb_sauts*delta_t)
                    valeur_y=vsel.y/(conv_vit*nb_sauts*delta_t)
                else:
                    valeur=vsel.d/(conv_vit*delta_t_exp)
                    valeur_x=vsel.x/(conv_vit*delta_t_exp)
                    valeur_y=vsel.y/(conv_vit*delta_t_exp)
            elif vsel.coul==force_coul:
                type_v=' Force '
                unite=' N '
                valeur=vsel.d/conv_f
                valeur_x=vsel.x/conv_f
                valeur_y=vsel.y/conv_f
            elif vsel.coul==accel_coul:
                type_v=' Accélération '
                unite=' m.s-2 '
                if numero_trace==0:
                    valeur=vsel.d/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                    valeur_x=vsel.x/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                    valeur_y=vsel.y/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                else:
                    valeur=vsel.d/(conv_vit*delta_t_exp)/(conv_accel*delta_t_exp)
                    valeur_x=vsel.x/(conv_vit*delta_t_exp)/(conv_accel*delta_t_exp)
                    valeur_y=vsel.y/(conv_vit*delta_t_exp)/(conv_accel*delta_t_exp)

            chaine2.configure(text='Vecteur '+type_v+' = '+str(int(1000000*valeur)/1000000)+unite, font="-size 10")
            chaine3.configure(text=type_v+'x = '+str(int(1000000*valeur_x)/1000000)+unite+type_v+'y = '+str(int(1000000*valeur_y)/1000000)+unite, font="-size 10")

def shift_pointeur(event):
    "Action sur un Majuscule-Clic-Gauche de souris"
    global psel, drapeau_sel_pt,list_v,sel_vect,list_pv,list_pv_exp,numero_trace
    pos_x=event.x
    pos_y=event.y
    drapeau_sel_pt2=0
    if drapeau_sel_pt==1 and len(l_coul)>1:   # tous est selectionné:
        if numero_trace==0:
            for p in list_p[numero_trace_sim]:
                d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if d<delta_pt2:
                    psel2=p
                    drapeau_sel_pt2=1
                    break
        else:
            for p in list_p_exp[numero_trace_exp]:
                d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if d<delta_pt2:
                    psel2=p
                    drapeau_sel_pt2=1
                    break



    if drapeau_sel_pt2==1 and psel2 != psel and len(l_coul)>1:   # tous est selectionné:
        # on a 2 points sélectionnés
        u=Vecteur((psel.x,psel.y),(psel2.x,psel2.y),'magenta',15)
        u.trace(u.coul,1)
        if numero_trace==0:
            list_v[numero_trace_sim].append(u)
            list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        else:
            list_v_exp[numero_trace_exp].append(u)
            list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
    if drapeau_sel_vect==1:
        if numero_trace==0 and len(l_coul)>1:   # tous est selectionné:
            for p in list_p[numero_trace_sim]:
                d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if d<delta_pt2:
                    u=Vecteur((p.x,p.y),(p.x+vsel.x,p.y+vsel.y),vsel.coul,15)
                    u.trace(u.coul,1)
                    list_v[numero_trace_sim].append(u)
                    list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                    break
        elif len(l_coul)>1:   # tous est selectionné:
            for p in list_p_exp[numero_trace_exp]:
                d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if d<delta_pt2:
                    u=Vecteur((p.x,p.y),(p.x+vsel.x,p.y+vsel.y),vsel.coul,15)
                    u.trace(u.coul,1)
                    list_v_exp[numero_trace_exp].append(u)
                    list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                    break
        if numero_trace==0 and len(l_coul)>1:   # tous est selectionné:
            for p in list_pv[numero_trace_sim]:
                d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if d<delta_pt2:
                    u=Vecteur((p.x,p.y),(p.x+vsel.x,p.y+vsel.y),vsel.coul,15)
                    u.trace(u.coul,1)
                    list_v[numero_trace_sim].append(u)
                    list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                    break
        elif len(l_coul)>1:   # tous est selectionné:
            for p in list_pv_exp[numero_trace_exp]:
                d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
                if d<delta_pt2:
                    u=Vecteur((p.x,p.y),(p.x+vsel.x,p.y+vsel.y),vsel.coul,15)
                    u.trace(u.coul,1)
                    list_v_exp[numero_trace_exp].append(u)
                    list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                    break
# recherche d'un vecteur

        drapeau_sel_vect2=0
        if numero_trace==0:
            for v in list_v[numero_trace_sim]:
                det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
                (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])
                d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1]))
                d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
                d3=v.d*ech_px
                if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
                d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                    vsel2=v
                    drapeau_sel_vect2=1
                    break
        else:
            for v in list_v_exp[numero_trace_exp]:
                det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
                (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])
                # print("det = ",det)
                d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1]))
                d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
                d3=v.d*ech_px
                if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
                d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                    vsel2=v
                    drapeau_sel_vect2=1
                    break

        if drapeau_sel_vect2==1:
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel2.P2[0],vsel2.P2[1]),vsel2.coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur


def ctrl_clic_droit(event):
    "Selection specifique d'une extremite de vecteur"
    global drapeau_sel_pt_ext, drapeau_sel_pt, psel
    pos_x=event.x
    pos_y=event.y
    if drapeau_sel_pt_ext==1:
        drapeau_sel_pt_ext=0
        psel.detruit()
    if drapeau_sel_pt==1:
        drapeau_sel_pt=0
        psel.change_coul('red',1)
    if numero_trace==0:
        for p in list_pv[numero_trace_sim]:
            d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
            if d<delta_pt2:
                psel=p
                drapeau_sel_pt_ext=1
                break
    else:
        for p in list_pv_exp[numero_trace_exp]:
            d=dist2((pos_x,pos_y),(int(ech_px*p.x),int(ech_px*p.y)))
            if d<delta_pt2:
                psel=p
                drapeau_sel_pt_ext=1
                break
    if drapeau_sel_pt_ext==1:
        psel.change_coul('dark green',2)

def man_vecteur(event):
    "Construction manuelle d'un vecteur par ctrl-shift-button-1"
    "Projection sur un vecteur"
    global list_p, list_v, list_pv, list_p_exp, list_v_exp, list_pv_exp
    if drapeau_sel_pt==1 or drapeau_sel_pt_ext==1:
        if drapeau_man==0:
            root.iconify()
            reponse=input("Pour placer un point : entrez l'abscisse x du point en mètre (origine en haut à gauche)")
            x_pos=float(reponse)
            reponse=input("Pour placer un point : entrez l'ordonnée y du point en mètre (origine en haut à gauche)")
            root.deiconify()
            y_pos=float(reponse)
            p=Point((x_pos,y_pos),'red')
            p.trace()
            if numero_trace==0:
                list_p[numero_trace_sim].append(p)
            else:
                list_p_exp[numero_trace_exp].append(p)
        elif drapeau_man==1:
            root.iconify()
            reponse=input("Pour tracer un vecteur déplacement depuis le point sélectionné: entrez sa composante x en mètre")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur déplacement depuis le point sélectionné: entrez sa composante y en mètre")
            y_pos=float(reponse)
            root.deiconify()
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos,psel.y+y_pos),'magenta',15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp.append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==2:
            root.iconify()
            reponse=input("Pour tracer un vecteur vitesse depuis le point sélectionné: entrez sa composante Vx en mètre par seconde")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur vitesse depuis le point sélectionné: entrez sa composante Vy en mètre par seconde")
            root.deiconify()
            y_pos=float(reponse)
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos*conv_vit*nb_sauts*delta_t,psel.y+y_pos*conv_vit*nb_sauts*delta_t),vit_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==3:
            root.iconify()
            reponse=input("Pour tracer un vecteur accélération depuis le point sélectionné: entrez sa composante ax en mètre par seconde au carré")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur accélération depuis le point sélectionné: entrez sa composante ay en mètre par seconde au carré")
            root.deiconify()
            y_pos=float(reponse)
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t,psel.y+y_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t),accel_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur


        else:
            root.iconify()
            reponse=input("Pour tracer un vecteur force depuis le point sélectionné: entrez sa composante Fx en newton")
            x_pos=float(reponse)
            reponse=input("Pour tracer un vecteur force depuis le point sélectionné: entrez sa composante Fy en newton")
            root.deiconify()
            y_pos=float(reponse)
            u=Vecteur((psel.x,psel.y),(psel.x+x_pos*conv_f,psel.y+y_pos*conv_f),force_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur


    if drapeau_sel_vect==1:
        drapeau_sel_vect2=0
        pos_x=event.x
        pos_y=event.y
        if numero_trace==0:
            for v in list_v[numero_trace_sim]:
                det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
                (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])
                # print("det = ",det)
                d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1]))
                d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
                d3=v.d*ech_px
                if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
                d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                    vsel2=v
                    drapeau_sel_vect2=1
                    break
        else:
            for v in list_v_exp[numero_trace_exp]:
                det=(pos_x-ech_px*v.P1[0])*(pos_y-ech_px*v.P2[1])-\
                (pos_y-ech_px*v.P1[1])*(pos_x-ech_px*v.P2[0])
                # print("det = ",det)
                d1=dist((pos_x,pos_y),(ech_px*v.P1[0],ech_px*v.P1[1]))
                d2=dist((pos_x,pos_y),(ech_px*v.P2[0],ech_px*v.P2[1]))
                d3=v.d*ech_px
                if det>-delta_vect2 and det<delta_vect2 and d1>delta_vect_ext and \
                d2>delta_vect_ext and d1<d3 and d2<d3 and (v.coul in l_coul):
                    vsel2=v
                    drapeau_sel_vect2=1
                    break
        if drapeau_sel_vect2==1:
            # vsel.selvect()
            Ftx=(vsel2.x*vsel.x+vsel2.y*vsel.y)*vsel.x/vsel.d/vsel.d
            Fty=(vsel2.x*vsel.x+vsel2.y*vsel.y)*vsel.y/vsel.d/vsel.d   # produit scalaire pour projeter sur vsel

            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+Ftx,vsel.P1[1]+Fty),vsel2.coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur


def man_vecteur_2(event):
    "Construction d'un point ou d'un vecteur colineaire a un autre vecteur, par CTRL-SHIFT-BOUTON-3"
    global list_p,list_v,list_pv
    if drapeau_sel_vect==1:
        if drapeau_man==0:
            root.iconify()
            reponse=input("Pour placer un point : entrez la distance en mètre depuis l'origine du vecteur sélectionné")
            x_pos=float(reponse)
            root.deiconify()
            p=Point((vsel.P1[0]+vsel.x/vsel.d*x_pos,vsel.P1[1]+vsel.y/vsel.d*x_pos),'red')
            p.trace()
            if numero_trace==0:
                list_p[numero_trace_sim].append(p)
            else:
                list_p_exp[numero_trace_exp].append(p)
        elif drapeau_man==1:
            root.iconify()
            reponse=input("Pour tracer un vecteur déplacement colinéaire au vecteur sélectionné : entrez sa valeur en mètre")
            x_pos=float(reponse)
            root.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*vsel.x/vsel.d,vsel.P1[1]+x_pos*vsel.y/vsel.d),'magenta',15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==2:
            root.iconify()
            reponse=input("Pour tracer un vecteur vitesse colinéaire au vecteur sélectionné: entrez sa valeur V en mètre par seconde")
            x_pos=float(reponse)
            root.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*conv_vit*nb_sauts*delta_t*vsel.x/vsel.d,vsel.P1[1]+x_pos*conv_vit*nb_sauts*delta_t*vsel.y/vsel.d),vit_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        elif drapeau_man==3:
            root.iconify()
            reponse=input("Pour tracer un vecteur accélération colinéaire au vecteur sélectionné: entrez sa valeur a en mètre par seconde au carré")
            x_pos=float(reponse)
            root.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t*vsel.x/vsel.d,\
            vsel.P1[1]+x_pos*conv_vit*nb_sauts*delta_t*conv_accel*nb_sauts*delta_t*vsel.y/vsel.d),accel_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        else:
            root.iconify()
            reponse=input("Pour tracer un vecteur force colinéaire au vecteur sélectionné: entrez sa valeur F en newton")
            x_pos=float(reponse)
            root.deiconify()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+x_pos*conv_f*vsel.x/vsel.d,vsel.P1[1]+x_pos*conv_f*vsel.y/vsel.d),force_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur


def conv_vitesse():
    "Mise à l'échelle d'une vitesse (bouton)"
    global vsel, list_v, list_pv, drapeau_sel_vect,list_v_exp,list_pv_exp
    if drapeau_sel_vect==1:
        if vsel.coul=='magenta':
            nbv=int(entree1.get())
            vsel.detruit()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+vsel.x*conv_vit/nbv,vsel.P1[1]+vsel.y*conv_vit/nbv),vit_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                a=list_v[numero_trace_sim].index(vsel)
                list_v[numero_trace_sim][a]=Vecteur((-1,-1),(-1,-1))
                drapeau_sel_vect=0
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                a=list_v_exp[numero_trace_exp].index(vsel)
                list_v_exp[numero_trace_exp][a]=Vecteur((-1,-1),(-1,-1))
                drapeau_sel_vect=0

def conv_acceleration():
    "Mise à l'échelle d'une accélération (bouton)"
    global vsel, list_v, list_pv, drapeau_sel_vect,list_v_exp,list_pv_exp
    if drapeau_sel_vect==1:
        if vsel.coul==vit_coul:
            nba=int(entree2.get())
            vsel.detruit()
            u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]+vsel.x*conv_accel/nba,vsel.P1[1]+vsel.y*conv_accel/nba),accel_coul,15)
            u.trace(u.coul,1)
            if numero_trace==0:
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                a=list_v[numero_trace_sim].index(vsel)
                list_v[numero_trace_sim][a]=Vecteur((-1,-1),(-1,-1))
                drapeau_sel_vect=0
            else:
                list_v_exp[numero_trace_exp].append(u)
                list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
                a=list_v_exp[numero_trace_exp].index(vsel)
                list_v_exp[numero_trace_exp][a]=Vecteur((-1,-1),(-1,-1))
                drapeau_sel_vect=0


def suppr_vect(event):
    "Suppression du vecteur sélectionné par Majuscule-Clic-Droit"
    global vsel, list_v,drapeau_sel_vect
    if drapeau_sel_vect==1:
        if numero_trace==0:
            vsel.detruit()
            a=list_v[numero_trace_sim].index(vsel)
            list_v[numero_trace_sim][a]=Vecteur((-1,-1),(-1,-1))
            drapeau_sel_vect=0
        else:
            vsel.detruit()
            a=list_v_exp[numero_trace_exp].index(vsel)
            list_v_exp[numero_trace_exp][a]=Vecteur((-1,-1),(-1,-1))
            drapeau_sel_vect=0

def aff_force(event):
    "Affichage du vecteur force par Controle-Clic sur un point sélectionné"
    if drapeau_sel_pt:
        if numero_trace==0:
            a=list_p[numero_trace_sim].index(psel)
            if a>=2:
                u=Vecteur((psel.x,psel.y),(psel.x+list_fx[numero_trace_sim][a-2]*conv_f,psel.y+list_fy[numero_trace_sim][a-2]*conv_f),force_coul,15)
                u.trace(u.coul,1)
                list_v[numero_trace_sim].append(u)
                list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        # en experimental il n'y a pas de force



def moins_vect(event):
    "Opposé du vecteur sélectionné par Clic-Droit"
    global vsel
    if drapeau_sel_vect==1:
        u=Vecteur((vsel.P1[0],vsel.P1[1]),(vsel.P1[0]-vsel.x,vsel.P1[1]-vsel.y),vsel.coul,15)
        u.trace(vsel.coul,1)
        if numero_trace==0:
            list_v[numero_trace_sim].append(u)
            list_pv[numero_trace_sim].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur
        else:
            list_v_exp[numero_trace_exp].append(u)
            list_pv_exp[numero_trace_exp].append(Point((u.P2[0],u.P2[1])))   # extrémité du vecteur

def choix_vecteur():
    "Action des boutons radio pour la sélection d'un vecteur"
    global l_coul, drapeau_man
    numero_vecteur=type_vecteur.get()
    if numero_vecteur==0:
        l_coul=['magenta',vit_coul,accel_coul,force_coul]
        drapeau_man=0
    elif numero_vecteur==1:
        l_coul=['magenta']
        drapeau_man=1
    elif numero_vecteur==2:
        l_coul=[vit_coul]
        drapeau_man=2
    elif numero_vecteur==3:
        l_coul=[accel_coul]
        drapeau_man=3
    else:
        l_coul=[force_coul]
        drapeau_man=4

def choix_exp_sim():
    global numero_trace
    numero_trace=type_trace.get()

def choix_exp_sim2(num):
    global numero_trace_sim,numero_trace,drapeau_sel_pt,psel,drapeau_sel_pt_ext,\
    drapeau_sel_vect,vsel
    if drapeau_sel_pt==1:
        psel.change_coul('red',1)
        drapeau_sel_pt=0
    if drapeau_sel_pt_ext==1:   # extremite de vecteur
        drapeau_sel_pt_ext=0
        psel.detruit()
    if drapeau_sel_vect==1:
        drapeau_sel_vect=0
        vsel.desel()
    numero_trace_sim=num
    numero_trace=0

def choix_exp_sim3(num):
    global numero_trace_exp,numero_trace,drapeau_sel_pt,psel,drapeau_sel_pt_ext,\
    drapeau_sel_vect,vsel
    if drapeau_sel_pt==1:
        psel.change_coul('red',1)
        drapeau_sel_pt=0
    if drapeau_sel_pt_ext==1:   # extremite de vecteur
        drapeau_sel_pt_ext=0
        psel.detruit()
    if drapeau_sel_vect==1:
        drapeau_sel_vect=0
        vsel.desel()
    numero_trace_exp=num+1    # 0 en debut de liste ?
    numero_trace=1


def dist(A,B):
    "Calcul de la distance entre 2 points"
    return sqrt((A[0]-B[0])**2+(A[1]-B[1])**2)

def dist2(A,B):
    "Calcul de la distance au carré"
    return (A[0]-B[0])**2+(A[1]-B[1])**2

def fonc_temps(t):
    nb_an=int(t/31557600)
    nb_jour=int((t-nb_an*31557600)/86400)
    nb_heure=int((t-nb_an*31557600-nb_jour*86400)/3600)
    nb_minute=int((t-nb_an*31557600-nb_jour*86400-nb_heure*3600)/60)
    nb_seconde=int((t-nb_an*31557600-nb_jour*86400-nb_heure*3600-nb_minute*60)*1000000)/1000000
    return str(nb_an)+" ans "+str(nb_jour)+" jours "+str(nb_heure)+" heures "+str(nb_minute)+" min "+str(nb_seconde)+" s"

def pointage():
    "Exploitation d'un pointage"
    global nb_cb_tra_exp_eff
    for i_cb in range (1,nb_cb_exp+1):
        axx.append(ch_9[i_cb].split(";"))
        ayy.append(ch_10[i_cb].split(";"))
    if((nb_cb_tra==3)and(nb_cb_exp==2)):
        axx.append([])
        ayy.append([])
        if((nb_cb_exp==2)and(len(axx[1])==len(ayy[1]))and(len(axx[1])!=0)and(len(axx[2])==len(ayy[2]))and(len(axx[1])==len(axx[2]))):
            for ind_cb in range(len(axx[1])):
                axx[3].append(str((float(axx[1][ind_cb])+float(axx[2][ind_cb]))/2)) # la courbe 3 est le milieu de la 1 et de la 2
                ayy[3].append(str((float(ayy[1][ind_cb])+float(ayy[2][ind_cb]))/2))
    maxx=float(axx[1][0])
    minx=float(axx[1][0])
    maxy=float(ayy[1][0])
    miny=float(ayy[1][0])
    for i_cb in range(1,nb_cb_tra+1):
        if((len(axx[i_cb])==len(ayy[i_cb]))and(len(axx[i_cb])!=0)):
            if(vcocher.get()==1):
                for ax in axx[i_cb]:
                    maxx=max(maxx,float(ax))
                for ax in axx[i_cb]:
                    minx=min(minx,float(ax))
                for ay in ayy[i_cb]:
                    maxy=max(maxy,float(ay))
                for ay in ayy[i_cb]:
                    miny=min(miny,float(ay))
    if(vcocher.get()==1):
        c_reelx=(minx+maxx)/2*coefpixpoint
        c_reely=(miny+maxy)/2*coefpixpoint
        c_fenx=dim_x/ech_px/2
        c_feny=dim_y/ech_px/2
        transpixpointx=c_fenx-c_reelx
        transpixpointy=c_feny-c_reely
    delta_t=ch_13
    list_p_exp.append([])
    list_fx_exp.append([])
    list_fy_exp.append([])
    list_v_exp.append([])
    list_pv_exp.append([])
    for i_cb in range(1,nb_cb_tra+1):
        nb_cb_tra_exp_eff=nb_cb_tra_exp_eff+1
        list_p_exp.append([])
        list_fx_exp.append([])
        list_fy_exp.append([])
        list_v_exp.append([])
        list_pv_exp.append([])
        nb_exp=0
        x_anc=float(axx[i_cb][ch_17])*coefpixpoint+transpixpointx
        y_anc=float(ayy[i_cb][ch_17])*coefpixpoint+transpixpointy
        longlist=min(len(axx[i_cb]),ch_17+ch_19)
        for ixy in range(ch_17,longlist):
            nb_exp=nb_exp+1
            p=Point((float(axx[i_cb][ixy])*coefpixpoint+transpixpointx,float(ayy[i_cb][ixy])*coefpixpoint+transpixpointy),'red')
            p.trace()
            list_p_exp[i_cb].append(p)
            list_fx_exp[i_cb].append(0)
            list_fy_exp[i_cb].append(0)
            can1.create_line(int(ech_px*x_anc),int(ech_px*y_anc),int(ech_px*(float(axx[i_cb][ixy])*coefpixpoint+transpixpointx)),int(ech_px*(float(ayy[i_cb][ixy])*coefpixpoint+transpixpointy)),fill='green')
            x_anc=float(axx[i_cb][ixy])*coefpixpoint+transpixpointx
            y_anc=float(ayy[i_cb][ixy])*coefpixpoint+transpixpointy
def e_f():
    global larg,ident,drapeau_sel_vect,vsel,drapeau_sel_pt,psel,drapeau_sel_pt_ext
    drapeau_sel_vect_anc=0
    drapeau_sel_pt_anc=0
    drapeau_sel_pt_ext_anc=0
    if drapeau_sel_vect==1:
        drapeau_sel_vect=0
        drapeau_sel_vect_anc=1
        for icb in range(nb_cb_tra_sim):
            if vsel in list_v[icb]:
                indvselvect=list_v[icb].index(vsel)
                icbselvect=icb
                icbtype=0
        for icb in range(1,nb_cb_tra_exp_eff+1):
            if vsel in list_v_exp[icb]:
                indvselvect=list_v_exp[icb].index(vsel)
                icbselvect=icb
                icbtype=1
        vsel.desel()
    if drapeau_sel_pt==1:
        drapeau_sel_pt=0
        drapeau_sel_pt_anc=1
        for icb in range(nb_cb_tra_sim):
            if psel in list_p[icb]:
                indpselpt=list_p[icb].index(psel)
                icbselpt=icb
                icbtype=0
        for icb in range(1,nb_cb_tra_exp_eff+1):
            if psel in list_p_exp[icb]:
                indpselpt=list_p_exp[icb].index(psel)
                icbselpt=icb
                icbtype=1
        psel.change_coul('red',1)
    if drapeau_sel_pt_ext==1:
        drapeau_sel_pt_ext=0
        drapeau_sel_pt_ext_anc=1
        for icb in range(nb_cb_tra_sim):
            if psel in list_pv[icb]:
                indpselpt=list_pv[icb].index(psel)
                icbselpt=icb
                icbtype=0
        for icb in range(1,nb_cb_tra_exp_eff+1):
            if vsel in list_pv_exp[icb]:
                indpselpt=list_pv_exp[icb].index(psel)
                icbselpt=icb
                icbtype=1
        psel.detruit()
    nbfic=int(entree3.get())
    nbfic=nbfic+1
    entree3.delete(0,END)
    entree3.insert(0,str(nbfic))
    cf=open('config.txt','w')
    cf.write(str(nbfic)+'\nNumero du dernier fichier mcb créé')
    cf.close()
    fw=open('mcb'+str(nbfic)+'.txt','w')
    fw.write('Ceci est le contenu du fichier mcb'+str(nbfic)+'.txt\n')
    if larg:
        ident=entree4.get()
        larg=False
    else:
        entree4.delete(0,END)
        entree4.insert(0,ident)
    fw.write('Identifiant définitif :\n'+ident+'\n')
    fw.write('Ce fichier contient les coordonnées des vecteurs déplacement, vitesse, accélération et force :\n')
    calcul=''
    for ich in range (len(ident)):
        calcul=calcul+str(ord(ident[ich]))+';'
    if(len(calcul)<1):
        calcul="Identifiant"
    fw.write(calcul)
    fw.write('\n')
    fw.write(str(nb_cb_tra_sim))
    fw.write('\n')
    for icb in range (nb_cb_tra_sim):
        for p in list_p[icb]:
            fw.write(str(p.x)+';')
        fw.write('\n')
        for p in list_p[icb]:
            fw.write(str(p.y)+';')
        fw.write('\n')
        for p in list_p[icb]:
            fw.write(p.coul+';')
        fw.write('\n')
        for p in list_p[icb]:
            fw.write(str(p.ep)+';')
        fw.write('\n')
    fw.write(str(nb_cb_tra_exp_eff))
    fw.write('\n')
    fw.write(str(delta_t))
    fw.write('\n')
    fw.write(str(delta_t_exp))
    fw.write('\n')
    fw.write(str(drapeau_sel_pt_anc))
    fw.write('\n')
    if(drapeau_sel_pt_anc==1):
        fw.write(str(icbselpt))
        fw.write('\n')
        fw.write(str(icbtype))
        fw.write('\n')
        fw.write(str(indpselpt))
        fw.write('\n')
        fw.write(str(psel.x))
        fw.write('\n')
        fw.write(str(psel.y))
        fw.write('\n')
        fw.write(psel.coul)
        fw.write('\n')
        fw.write(str(psel.ep))
        fw.write('\n')
    else:
        fw.write('1\n1\n1\n1\n1\n1\n1\n')
    fw.write(str(drapeau_sel_vect_anc))
    fw.write('\n')
    if(drapeau_sel_vect_anc==1):
        fw.write(str(icbselvect))
        fw.write('\n')
        fw.write(str(icbtype))
        fw.write('\n')
        fw.write(str(indvselvect))
        fw.write('\n')
        fw.write(str(vsel.P1[0]))
        fw.write('\n')
        fw.write(str(vsel.P1[1]))
        fw.write('\n')
        fw.write(str(vsel.P2[0]))
        fw.write('\n')
        fw.write(str(vsel.P2[1]))
        fw.write('\n')
        fw.write(vsel.coul)
        fw.write('\n')
        fw.write(str(vsel.lp))
        fw.write('\n')
    else:
        fw.write('1\n1\n1\n1\n1\n1\n1\n1\n1\n')
    fw.write(str(drapeau_sel_pt_ext_anc))
    fw.write('\n')
    if(drapeau_sel_pt_ext_anc==1):
        fw.write(str(icbselpt))
        fw.write('\n')
        fw.write(str(icbtype))
        fw.write('\n')
        fw.write(str(indpselpt))
        fw.write('\n')
        fw.write(str(psel.x))
        fw.write('\n')
        fw.write(str(psel.y))
        fw.write('\n')
        fw.write(psel.coul)
        fw.write('\n')
        fw.write(str(psel.ep))
        fw.write('\n')
    else:
        fw.write('1\n1\n1\n1\n1\n1\n1\n')

    for icb in range (nb_cb_tra_sim):
        nblu=len(list_v[icb])
        fw.write(str(len(list_v[icb])))  # elles n'ont pas toutes la même longueur
        fw.write('\n')
        if nblu>0:
            for vw in list_v[icb]:
                fw.write(str(vw.P1[0])+';')
            fw.write('\n')
            for vw in list_v[icb]:
                fw.write(str(vw.P1[1])+';')
            fw.write('\n')
            for vw in list_v[icb]:
                fw.write(str(vw.P2[0])+';')
            fw.write('\n')
            for vw in list_v[icb]:
                fw.write(str(vw.P2[1])+';')
            fw.write('\n')
            for vw in list_v[icb]:
                fw.write(vw.coul+';')
            fw.write('\n')
            for vw in list_v[icb]:
                fw.write(str(vw.lp)+';')
            fw.write('\n')
    for i_cb in range(1,nb_cb_tra_exp_eff+1):
        nblu=len(list_p_exp[i_cb])
        fw.write(str(len(list_p_exp[i_cb])))
        fw.write('\n')
        if nblu>0:
            for p in list_p_exp[i_cb]:
                fw.write(str(p.x)+';')
            fw.write('\n')
            for p in list_p_exp[i_cb]:
               fw.write(str(p.y)+';')
            fw.write('\n')
            for p in list_p_exp[i_cb]:
                fw.write(p.coul+';')
            fw.write('\n')
            for p in list_p_exp[i_cb]:
                fw.write(str(p.ep)+';')
            fw.write('\n')
        nblu=len(list_v_exp[i_cb])
        fw.write(str(len(list_v_exp[i_cb])))
        fw.write('\n')
        if nblu>0:
            for vw in list_v_exp[i_cb]:
                fw.write(str(vw.P1[0])+';')
            fw.write('\n')
            for vw in list_v_exp[i_cb]:
                fw.write(str(vw.P1[1])+';')
            fw.write('\n')
            for vw in list_v_exp[i_cb]:
                fw.write(str(vw.P2[0])+';')
            fw.write('\n')
            for vw in list_v_exp[i_cb]:
                fw.write(str(vw.P2[1])+';')
            fw.write('\n')
            for vw in list_v_exp[i_cb]:
                fw.write(vw.coul+';')
            fw.write('\n')
            for vw in list_v_exp[i_cb]:
                fw.write(str(vw.lp)+';')
            fw.write('\n')
    if drapeau_sel_vect_anc==1:
        drapeau_sel_vect=1
        drapeau_sel_vect_anc=0
        if icbtype==0:
            vsel=list_v[icbselvect][indvselvect]
        else:
            vsel=list_v_exp[icbselvect][indvselvect]
        vsel.selvect()
    if drapeau_sel_pt_anc==1:
        drapeau_sel_pt=1
        drapeau_sel_pt_anc=0
        if icbtype==0:
            psel=list_p[icbselpt][indpselpt]
        else:
            psel=list_p_exp[icbselpt][indpselpt]
        psel.change_coul('dark green',2)
    if drapeau_sel_pt_ext_anc==1:
        drapeau_sel_pt_ext=1
        drapeau_sel_pt_ext_anc=0
        if(icbtype==0):
            psel=list_pv[icbselpt][indpselpt]
        else:
            psel=list_pv_exp[icbselpt][indpselpt]
        psel.change_coul('dark green',2)
    fw.close()

def o_f():
    global larg,ident,nb_cb_tra,delta_t,delta_t_exp,list_p,list_v, \
    psel, drapeau_sel_pt,drapeau_sel_vect,vsel,drapeau_sel_pt_ext, \
    list_pv,list_pv_exp,nb_cb_tra_exp_eff,numero_trace,numero_trace_exp,\
    numero_trace_sim
    nbfic=int(entree3.get())
    if nbfic!=0:
        fr=open('mcb'+str(nbfic)+'.txt','r')
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=fr.readline()
        lire=lire[0:-1]
        lireli=lire.split(";")
        id=''
        del lireli[-1]
        larg=False
        for a in lireli:
            id=id+chr(int(a))
        entree4.delete(0,END)
        entree4.insert(0,id)
        ident=id
        lire=fr.readline()  # nb courbes theoriques
        nb_cb_tra_sim=int(lire[0:-1])
        list_p=[]
        list_v=[]
        list_pv=[]
        for icb in range(nb_cb_tra_sim):
            list_p.append([])
            list_v.append([])
            list_pv.append([])
        for icb in range(nb_cb_tra_sim):
            lire=fr.readline()
            lire=lire[0:-1]
            lireli=lire.split(";")
            del lireli[-1]
            cx=[0,1]
            cx[0]=[]
            cx[1]=[]
            for a in lireli:
                cx[0].append(float(a))
            x_anc=cx[0][1]
            lire=fr.readline()
            lire=lire[0:-1]
            lireli=lire.split(";")
            del lireli[-1]
            for a in lireli:
                cx[1].append(float(a))
            y_anc=cx[1][1]
            lire=fr.readline()
            lire=lire[0:-1]
            lireli=lire.split(";")
            coul=[]
            for a in lireli:
                coul.append(a)
            lire=fr.readline()
            lire=lire[0:-1]
            lireli=lire.split(";")
            del lireli[-1]
            ep=[]
            for a in lireli:
                ep.append(int(a))
            ab=[0,1]
            for ilire in range(len(lireli)):
                ab[0]=cx[0][ilire]
                ab[1]=cx[1][ilire]
                pp=Point(ab,coul[ilire],ep[ilire])
                list_p[icb].append(pp)
                pp.trace()
            for ilire in range (2,len(lireli)):
                can1.create_line(int(ech_px*x_anc),int(ech_px*y_anc),int(ech_px*list_p[icb][ilire].x),int(ech_px*list_p[icb][ilire].y),fill='blue')
                x_anc=list_p[icb][ilire].x
                y_anc=list_p[icb][ilire].y
        lire=fr.readline()
        nb_cb_tra_exp_eff=int(lire[0:-1])
        lire=fr.readline()
        delta_t=float(lire[0:-1])
        lire=fr.readline()
        delta_t_exp=float(lire[0:-1])
        lire=fr.readline()
        drapeau_sel_pt=int(lire[0:-1])
        if(drapeau_sel_pt==1):
            lire=fr.readline()
            icblu=int(lire[0:-1])
            lire=fr.readline()
            icbtype=int(lire[0:-1])
            lire=fr.readline()
            indpselpt=int(lire[0:-1])
            xlire=[]
            lire=fr.readline()
            xlire.append(float(lire[0:-1]))
            lire=fr.readline()
            xlire.append(float(lire[0:-1]))
            lire=fr.readline()
            xcoul=lire[0:-1]
            lire=fr.readline()
            xep=int(lire[0:-1])
            psel=Point(xlire,xcoul,xep)
        else:
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
        lire=fr.readline()
        drapeau_sel_vect=int(lire[0:-1])
        if drapeau_sel_vect==1:
            lire=fr.readline()
            icblu=int(lire[0:-1])
            lire=fr.readline()
            icbtype=int(lire[0:-1])
            lire=fr.readline()
            indvselvect=int(lire[0:-1])
            lire=fr.readline()
            lire=lire[0:-1]
            a1xs=float(lire)
            lire=fr.readline()
            lire=lire[0:-1]
            a1ys=float(lire)
            lire=fr.readline()
            lire=lire[0:-1]
            a2xs=float(lire)
            lire=fr.readline()
            lire=lire[0:-1]
            a2ys=float(lire)
            lire=fr.readline()
            couls=lire[0:-1]
            lire=fr.readline()
            lire=lire[0:-1]
            fls=int(lire)
        else:
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
        lire=fr.readline()
        drapeau_sel_pt_ext=int(lire[0:-1])
        if(drapeau_sel_pt_ext==1):
            lire=fr.readline()
            icblu=int(lire[0:-1])
            lire=fr.readline()
            icbtype=int(lire[0:-1])
            lire=fr.readline()
            indpselpt=int(lire[0:-1])
            xlire=[]
            lire=fr.readline()
            xlire.append(float(lire[0:-1]))
            lire=fr.readline()
            xlire.append(float(lire[0:-1]))
            lire=fr.readline()
            xcoul=lire[0:-1]
            lire=fr.readline()
            xep=int(lire[0:-1])
            psel=Point(xlire,xcoul,xep)
        else:
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
            lire=fr.readline()
        for icb in range(nb_cb_tra_sim):
            lire=fr.readline()
            nblu=int(lire[0:-1])
            if nblu>0:
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a1x=[]
                for a in lireli:
                    a1x.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a1y=[]
                for a in lireli:
                    a1y.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a2x=[]
                for a in lireli:
                    a2x.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a2y=[]
                for a in lireli:
                    a2y.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                coul=[]
                for a in lireli:
                    coul.append(a)
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                ep=[]
                for a in lireli:
                    ep.append(int(a))
                for ilire in range(len(lireli)):
                    v=Vecteur((a1x[ilire],a1y[ilire]),(a2x[ilire],a2y[ilire]),coul[ilire],ep[ilire])
                    v.trace(coul[ilire],1)
                    list_v[icb].append(v)
                    list_pv[icb].append(Point((v.P2[0],v.P2[1])))   # extrémité du vecteur
        list_p_exp.append([])
        list_fx_exp.append([])
        list_fy_exp.append([])
        list_v_exp.append([])
        list_pv_exp.append([])
        for i_cb in range(1,nb_cb_tra_exp_eff+1):
            list_p_exp.append([])
            list_fx_exp.append([])
            list_fy_exp.append([])
            list_v_exp.append([])
            list_pv_exp.append([])
            lire=fr.readline()
            nblu=int(lire[0:-1])
            if(nblu>0):
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                list_p_exp[i_cb]=[]
                cx=[0,1]
                cx[0]=[]
                cx[1]=[]
                for a in lireli:
                    cx[0].append(float(a))
                x_anc=cx[0][0]
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                for a in lireli:
                    cx[1].append(float(a))
                y_anc=cx[1][0]
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                coul=[]
                for a in lireli:
                    coul.append(a)
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                ep=[]
                for a in lireli:
                    ep.append(int(a))
                ab=[0,1]
                for ilire in range(len(lireli)):
                    ab[0]=cx[0][ilire]
                    ab[1]=cx[1][ilire]
                    pp=Point(ab,coul[ilire],ep[ilire])
                    list_p_exp[i_cb].append(pp)
                    pp.trace()
                for ilire in range (1,len(lireli)):
                    can1.create_line(int(ech_px*x_anc),int(ech_px*y_anc),int(ech_px*list_p_exp[i_cb][ilire].x),int(ech_px*list_p_exp[i_cb][ilire].y),fill='green')
                    x_anc=list_p_exp[i_cb][ilire].x
                    y_anc=list_p_exp[i_cb][ilire].y
            lire=fr.readline()
            nblu=int(lire[0:-1])
            if(nblu>0):
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a1x=[]
                for a in lireli:
                    a1x.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a1y=[]
                for a in lireli:
                    a1y.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a2x=[]
                for a in lireli:
                    a2x.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                a2y=[]
                for a in lireli:
                    a2y.append(float(a))
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                coul=[]
                for a in lireli:
                    coul.append(a)
                lire=fr.readline()
                lire=lire[0:-1]
                lireli=lire.split(";")
                del lireli[-1]
                ep=[]
                for a in lireli:
                    ep.append(int(a))
                for ilire in range(len(lireli)):
                    v=Vecteur((a1x[ilire],a1y[ilire]),(a2x[ilire],a2y[ilire]),coul[ilire],ep[ilire])
                    v.trace(coul[ilire],1)
                    list_v_exp[i_cb].append(v)
                    list_pv_exp[i_cb].append(Point((v.P2[0],v.P2[1])))   # extrémité du vecteur
        if drapeau_sel_vect==1:
            if icbtype==0:
                vsel=list_v[icblu][indvselvect]
                numero_trace=0
                numero_trace_sim=icblu
            else:
                vsel=list_v_exp[icblu][indvselvect]
                numero_trace=1
                numero_trace_exp=icblu
            vsel.selvect()
            if vsel.coul=='magenta':
                type_v=' Déplacement '
                unite=' m '
                valeur=vsel.d
                valeur_x=vsel.x
                valeur_y=vsel.y
            elif vsel.coul==vit_coul:
                type_v=' Vitesse '
                unite=' m.s-1 '
                if icbtype==0:
                    valeur=vsel.d/(conv_vit*nb_sauts*delta_t)
                    valeur_x=vsel.x/(conv_vit*nb_sauts*delta_t)
                    valeur_y=vsel.y/(conv_vit*nb_sauts*delta_t)
                else:
                    valeur=vsel.d/(conv_vit*delta_t_exp)
                    valeur_x=vsel.x/(conv_vit*delta_t_exp)
                    valeur_y=vsel.y/(conv_vit*delta_t_exp)
            elif vsel.coul==force_coul:
                type_v=' Force '
                unite=' N '
                valeur=vsel.d/conv_f
                valeur_x=vsel.x/conv_f
                valeur_y=vsel.y/conv_f
            elif vsel.coul==accel_coul:
                type_v=' Accélération '
                unite=' m.s-2 '
                if icbtype==0:
                    valeur=vsel.d/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                    valeur_x=vsel.x/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                    valeur_y=vsel.y/(conv_vit*nb_sauts*delta_t)/(conv_accel*nb_sauts*delta_t)
                else:
                    valeur=vsel.d/(conv_vit*delta_t_exp)/(conv_accel*delta_t_exp)
                    valeur_x=vsel.x/(conv_vit*delta_t_exp)/(conv_accel*delta_t_exp)
                    valeur_y=vsel.y/(conv_vit*delta_t_exp)/(conv_accel*delta_t_exp)

            chaine2.configure(text='Vecteur '+type_v+' = '+str(int(1000000*valeur)/1000000)+unite, font="-size 10")
            chaine3.configure(text=type_v+'x = '+str(int(1000000*valeur_x)/1000000)+unite+type_v+'y = '+str(int(1000000*valeur_y)/1000000)+unite, font="-size 10")
        if drapeau_sel_pt==1:
            if icbtype==0:
                psel=list_p[icblu][indpselpt]
                numero_trace=0
                numero_trace_sim=icblu
            else:
                psel=list_p_exp[icblu][indpselpt]
                numero_trace=1
                numero_trace_exp=icblu
            psel.change_coul('dark green',2)
            chaine1.configure(text='Point sélectionné x = '+str(int(1000000*psel.x)/1000000)+' m, y = '+str(int(1000000*psel.y)/1000000)+' m', font="-size 10")
            if icbtype==0:
                ind_pt=list_p[icblu].index(psel)
                temps_sel=(ind_pt-1)*delta_t*nb_sauts
            else:
                ind_pt=list_p_exp[icblu].index(psel)
                temps_sel=ind_pt*delta_t_exp
            chaine8.configure(text="Point sélectionné : instant t = "+str(int(temps_sel*1000000)/1000000)+' s = '+fonc_temps(temps_sel), font="-size 10")
        if drapeau_sel_pt_ext==1:
            if(icbtype==0):
                psel=list_pv[icblu][indpselpt]
                numero_trace=0
                numero_trace_sim=icblu
            else:
                psel=list_pv_exp[icblu][indpselpt]
                numero_trace=1
                numero_trace_exp=icblu
            psel.change_coul('dark green',2)

        fr.close()

class AutoScrollbar(Scrollbar):
    # a scrollbar that hides itself if it's not needed.  only
    # works if you use the grid geometry manager.
    def set(self, lo, hi):
        if float(lo) <= 0.0 and float(hi) >= 1.0:
            # grid_remove is currently missing from Tkinter!
            self.tk.call("grid", "remove", self)
        else:
            self.grid()
        Scrollbar.set(self, lo, hi)

class MaFrame(Frame) :
    def __init__(self, parent) :
        self._vscrollbar = AutoScrollbar(parent)
        self._vscrollbar.grid(row=0, column=1, sticky=NS)
        self._hscrollbar = AutoScrollbar(parent, orient=HORIZONTAL)
        self._hscrollbar.grid(row=1, column=0, sticky=EW)
        self._can = Canvas(parent, bg='white',
                              yscrollcommand=self._vscrollbar.set,
                              xscrollcommand=self._hscrollbar.set)

        self._can.grid(row=0, column=0, sticky=NSEW)
        self._vscrollbar.config(command=self._can.yview)
        self._hscrollbar.config(command=self._can.xview)

        super().__init__(self._can)
        self._can.create_window(0, 0, anchor=NW, window=self, state=NORMAL)
        self.bind('<Configure>', self._actualiserDimension)

    def _actualiserDimension(self, evt) :
        self._can.config(scrollregion=self._can.bbox("all"))

    def grid(self, **dargs) :
        ''' Ne pas grid la Frame '''
        pass

class ComboBox(Frame):
    "Widget composite associant un champ d'entrée avec une boîte de liste"
    def __init__(self, boss, item='',items=[], command='',width=10, listSize=5):
        Frame.__init__(self,boss)
        # constructeur de la classe parente
        # (<boss> est la référence du widget 'maître')
        self.items = items # items à placer dans la boîte de liste
        self.command=command # fonction à invoquer après clic ou <Enter>
        self.item=item  # item entré ou sélectionné

        # Boîte de liste, munie d'un ascenseur (scroll bar) :
        cadreLB=Frame(self)   # cadre pour l'ensemble des 2
        self.bListe=Listbox(cadreLB, height=listSize, width=width-1)
        scrol=Scrollbar(cadreLB, command=self.bListe.yview)
        self.bListe.config(yscrollcommand=scrol.set)
        self.bListe.bind("<ButtonRelease-1>",self.sortieL)
        self.bListe.pack(side=LEFT)
        scrol.pack(expand=YES, fill=Y)
        cadreLB.pack()

        #Remplissage de la boîte de liste avec les items fournis:
        for it in items:
            self.bListe.insert(END, it)

    def sortieL(self, event=None):
        # Extraire de la liste l'item qui a été sélectionné :
        index=self.bListe.curselection()  # renvoie un tuple d'index
        ind0=int(index[0]) # on ne garde que le premier
        self.item=self.items[ind0]
        self.command(ind0)

    def get(self):
        # Renvoyer le dernier item sélectionné dans la boîte de liste
        return self.item

courbessim=('simulation 1','simulation 2','simulation 3')
courbesexp=('expérience 1','expérience 2','expérience 3')

# Programme principal

root=Tk()
root.grid_rowconfigure(0, weight=1)
root.grid_columnconfigure(0, weight=1)
ws = root.winfo_screenwidth() # width of the screen
hs = root.winfo_screenheight() # height of the screen
fen1 = MaFrame(root)
#root.geometry("1500x850+-400+0")
#root.geometry("1500x850+-400+0")
root.geometry("%dx%d+%d+%d" % (ws-45, hs-90, 0, 0))
combo=ComboBox(fen1,item="néant",items=courbesexp,command=choix_exp_sim3,width=15,listSize=3)
combo.grid(row=13,rowspan=2, column=1)
combosim=ComboBox(fen1,item="néant",items=courbessim,command=choix_exp_sim2,width=15,listSize=3)
combosim.grid(row=13,rowspan=2, column=2)

# variables globales
pi_314=acos(-1)
dim_x=800       # dimensions de la fenêtre  800
dim_y=800
ech_px=800   #echelle : nombre de pixels pour un mètre   25 pour le manege coriolis 800 bille pesanteur
x2 = dim_x/2/ech_px  # point d'attache du fil et du ressort au centre
y2 = dim_y/2/ech_px
z2=0

duree_tour=13.33333333333333  # duree en seconde pour 1 tour de manege
omega=-2*pi_314/duree_tour
R_man=7.0     # rayon du manege en m
L=0.9                # distance initiale par rapport au centre
angle=-75   # angle initial en degrés par rapport à la verticale
vr0=-2.5               # vitesse initiale radiale
val0=-3              # vitesse initiale orthoradiale

# Données à modifier :  ############################################
nb_cb_sim=1       # 2 courbes théoriques calculées (simulation)
nb_cb_tra_sim=1   # 3 courbes théoriques tracées : centre d'inertie en plus
g=9.81        # intensité de la pesanteur en m.s-2
masse=[0.20,0.20]     # masse 1 et 2 en kg
xx0=[0.1,0.5,0]            # abscisses initiales en mètre (3 valeurs, pour les 2 points et pour le centre de gravité)
yy0=[0.7,0.6,0]            # ordonnées initiales en mètre
zz0=[0,0,0]                    # coordonnée z en mètre

v0x=[0.7,0.73,0]         # vitesse initiale suivant x en m.s-1
v0y=[-3,0-1.0,0]        # vitesse initiale suivant y en m.s-1
v0z=[0,0,0]            # vitesse initiale suivant z

def force_x(ifcalc,X,Y,VX,VY,Temps):  # ifcalc identifie chaque point matériel du système (sous systèmes)
    return 0
def force_y(ifcalc,X,Y,VX,VY,Temps):
    return masse[ifcalc]*g

coefvitsim=1.0      # ajustement de la valeur de la vitesse
coefvitdir=1.0      # ajustement de la direction de la vitesse


# #################################################################
nb_cb_tra_sim_eff=0                  # nombre de courbes effectivement tracées
nb_cb_tra_exp_eff=0                  # nombre de courbes effectivement tracées
v0x[0]=v0x[0]*coefvitsim/coefvitdir   # trajectoire suivant y dans le rérérentiel Galileen
v0y[0]=v0y[0]*coefvitsim*coefvitdir

for itsim in range(nb_cb_sim):    #
    xx0[itsim]=xx0[itsim]-x2     # mettre en commentaire ces 3 lignes si l'origine des coordonnées est au centre
    yy0[itsim]=yy0[itsim]-y2            # mettre en commentaire ces 3 lignes si l'origine des coordonnées est au centre

x0=[]
y0=[]
z0=[]
for itsim in range(nb_cb_tra_sim):
    x0.append(0)
    y0.append(0)
    z0.append(0)
for itsim in range(nb_cb_sim):   #
    x0[itsim]=xx0[itsim]+x2     # utilisé pour les calculs
    y0[itsim]=yy0[itsim]+y2     # utilisé pour les calculs
    z0[itsim]=zz0[itsim]        # utilisé pour les calculs
F0x=[]
F0y=[]
Fx=[]
Fy=[]
Fz=[]
if nb_cb_tra_sim>=3:
    x0[2]=(x0[0]*masse[0]+x0[1]*masse[1])/(masse[0]+masse[1])   # centre de gravité
    y0[2]=(y0[0]*masse[0]+y0[1]*masse[1])/(masse[0]+masse[1])
    z0[2]=(z0[0]*masse[0]+z0[1]*masse[1])/(masse[0]+masse[1])
for itsim in range(nb_cb_tra_sim):
    Fx.append(0)
    Fy.append(0)
    Fz.append(0)
for itsim in range(nb_cb_sim):
    F0x.append(0)
    F0y.append(0)
    F0x[itsim]=force_x(itsim,x0,y0,v0x,v0y,0)  # initialisation des forces
    F0y[itsim]=force_y(itsim,x0,y0,v0x,v0y,0)
force_coul='#924e25'  # force : couleur du vecteur
vit_coul='#d36069'   # vitesse : couleur du vecteur
accel_coul='#39dbf4'  # accélération : : couleur du vecteur
l_coul=['magenta',vit_coul,accel_coul,force_coul]
nb_sauts=20 #  Nombre de pas de tempsentre 2 croix rouges de trajectoire  20
conv_f=0.1 #  Echelle géométrique pour les vecteurs force en pixel par newton
list_fx=[]
list_fy=[]
list_fz=[]
for icb in range (nb_cb_tra_sim):
    list_fx.append([])
    list_fy.append([])
    list_fz.append([])
list_fx_exp=[]
list_fy_exp=[]
list_fz_exp=[]
conv_vit=5.0 # Echelle géométrique pour les vecteurs vitesse en pixel par mètre par seconde : 2.0  5.0  1.5  4.0  4.6
conv_accel=3.0 # Echelle géométrique pour les vecteurs accélération en pixel/(m.s-2)  1.2
drapeau_sel_vect=0
vsel=None
drapeau_man=0   # pour la création d'un point ou d'un vecteur par ses coordonnées
drapeau_sel_pt=0  # 1 si un point est sélectionné
drapeau_sel_pt_ext=0  # 1 si un point extremite de vecteur est sélectionné
psel=Point((0,0))   # point selectionné
delta_pt=2  # distance pour sélectionner un point en pixel 4
delta_pt2=delta_pt**2
delta_vect_ext=2  # distance des extrémités pour ne pas sélectionner un vecteur 12
delta_vect_ext2=delta_vect_ext**2
delta_vect=20  # pour tester la nullité du déterminant pour sélectionner un vecteur
delta_vect2=delta_vect*delta_vect  # pour le déterminant
delta_t=0.001      # pas de temps pour les simulations
delta_t_exp=0.02    # pas de temps pour le calcul  0.001
rk_h=delta_t      # pour Runge-Kutta
rk_hh=rk_h/2.0
rk_h6=rk_h/6
rk_th=0        # instant pour Runge-Kutta
l2=0.35          # longueur de fil supplémentaire
l0=0.1          # longueur à vide du ressort
k1=20          # raideur du ressort en N.m-1 en x
k2=30          # idem en y
k3=10
duree=10000    # animation
seuil=1e-10
drapeau=0
drapeau_p=0
drapeau_k=0
drapeau_t=0
drapeau_pp=0
nb_pts=0
liste_al_max=[]
liste_al_min=[]
rk_x=[]
rk_v=[]
dydx_x=[]
dydx_v=[]
dydx_dyt_x=[]
dydx_dyt_v=[]
dydx_dym_x=[]
dydx_dym_v=[]
rk_x_yt1=[]
rk_v_yt1=[]
rk_x_yt2=[]
rk_v_yt2=[]
rk_x_yt3=[]
rk_v_yt3=[]
for icoord in range(3):
    rk_x.append(0)
    rk_v.append(0)
    dydx_x.append(0)
    dydx_v.append(0)
    dydx_dyt_x.append(0)
    dydx_dyt_v.append(0)
    dydx_dym_x.append(0)
    dydx_dym_v.append(0)
    rk_x_yt1.append([])
    rk_v_yt1.append([])
    rk_x_yt2.append([])
    rk_v_yt2.append([])
    rk_x_yt3.append([])
    rk_v_yt3.append([])
    for itsim in range(nb_cb_sim):
        rk_x_yt1[icoord].append(0)
        rk_v_yt1[icoord].append(0)
        rk_x_yt2[icoord].append(0)
        rk_v_yt2[icoord].append(0)
        rk_x_yt3[icoord].append(0)
        rk_v_yt3[icoord].append(0)


courbe_x=[0,1]
courbe_y=[0,1]
courbe_z=[0,1]
courbe_x[0]=[]
courbe_y[0]=[]
courbe_z[0]=[]

courbe_x[0].append(x0[0])
courbe_y[0].append(y0[0])
courbe_z[0].append(z0[0])
rac2=sqrt(2)/2

x1=[]
y1=[]
z1=[]
x_anc=[]
y_anc=[]
z_anc=[]
vx=[]
vy=[]
vz=[]
for itsim in range(nb_cb_tra_sim):
    x1.append(x0[itsim])
    y1.append(y0[itsim])
    z1.append(z0[itsim])
    x_anc.append(x1[itsim])
    y_anc.append(y1[itsim])
    z_anc.append(z1[itsim])
    vx.append(v0x[itsim])
    vy.append(v0y[itsim])
    vz.append(v0z[itsim])

d0=sqrt((x0[0]-x2)**2+(y0[0]-y2)**2)
cosalpha0=1
sinalpha0=0
singamma0=0
alpha_anc=0
d_anc=0
lpointe=5  # nombre de pixels de la pointe d'un vecteur
trajectoire=[]
temps=0
can1=Canvas(fen1,bg='dark grey',height=dim_y,width=dim_x)
can1.grid(column=0,row=0,rowspan=15)
oval1=[0,0,0]
oval1[0]=can1.create_oval(int(ech_px*x1[0])-5,int(ech_px*y1[0])-5,int(ech_px*x1[0])+5, int(ech_px*y1[0])+5, width=2, fill='red')
if nb_cb_sim>=2:
    oval1[1]=can1.create_oval(int(ech_px*x1[1])-5,int(ech_px*y1[1])-5,int(ech_px*x1[1])+5, int(ech_px*y1[1])+5, width=2, fill='red')
bou1=Button(fen1,text='Quitter', width=8,command=fen1.quit)
bou1.grid(row=11,column=3)
bou2=Button(fen1, text='Démarrer',width=8,command=start_it)
bou2.grid(row=0, column =2)
bou3=Button(fen1,text='Arrêter',width=8,command=stop_it)
bou3.grid(row=0, column=3)
bou4=Button(fen1, text='Trajectoire',width=8,command=traject)
bou4.grid(row=0,column=1)
type_trace=IntVar()
type_trace.set(0)
numero_trace=0
numero_trace_sim=0
numero_trace_exp=1
larg=True
p=Point((x2,y2),'black')
p.trace()
list_p=[]   # liste des points pour chaque point matériel du système
list_p_exp=[] # on fait une liste a part pour les points experimentaux
list_v=[]
list_v_exp=[]
list_pv=[]  # points extémités de vecteurs
list_pv_exp=[]
for icb in range(nb_cb_tra_sim):
    list_p.append([])
    list_v.append([])
    list_pv.append([])
    list_p[icb].append(p)
p=Point((x1[0],y1[0]),'red')
p.trace()
list_p[0].append(p)
if nb_cb_sim>=2:
    p=Point((x1[1],y1[1]),'red')
    p.trace()
    list_p[1].append(p)
if nb_cb_tra_sim>=3:
    p=Point(((x1[0]*masse[0]+x1[1]*masse[1])/(masse[0]+masse[1]),(y1[0]*masse[0]+y1[1]*masse[1])/(masse[0]+masse[1])),'red')
    list_p[2].append(p)
    p.trace()
bou5=Button(fen1, text='Eff Points',width=8,command=detruit_dernier)
bou5.grid(row=11,column=1)
bou6=Button(fen1, text='Visu Points',width=8,command=visualisation_points)
bou6.grid(row=11,column=2)
bou7=Button(fen1, text='Déplacement --> Vitesse',width=18,command=conv_vitesse)
bou7.grid(row=1, column=1)
bou8=Button(fen1, text='Vitesse --> Accélération',width=18,command=conv_acceleration)
bou8.grid(row=1, column=3)
chaine4=Label(fen1)
chaine5=Label(fen1)
chaine4.grid(row=3,column=1)
chaine4.configure(text="Nb pas vitesse", font="-size 10")
chaine5.grid(row=3,column=3)
chaine5.configure(text="Nb pas accélération", font="-size 10")
entree1=Entry(fen1,width=5)
entree1.grid(row=2,column=1)
entree2=Entry(fen1,width=5)
entree2.grid(row=2,column=3)
entree1.insert(0,'2')
entree2.insert(0,'2')
entree3=Entry(fen1,width=10)
entree3.grid(row=13,column=5)
entree4=Entry(fen1,width=40,fg='red')
entree4.grid(row=0,column=4,columnspan=2)
ident='Identifiant définitif demandé'
entree4.insert(0,ident)
lbl4=Label(fen1)
lbl4.grid(row=1,column=4,columnspan=2)
lbl4.configure(text="Identifiant définitif", font="-size 10")
bou10=Button(fen1,text='Ouvrir mcb_nn.txt',width=18,command=o_f)
bou10.grid(row=13,column=4)
bou11=Button(fen1,text='Enregistrer mcb_nn+1.txt',width=20,command=e_f)
bou11.grid(row=12,column=4)
type_vecteur=IntVar()
type_vecteur.set(0)
choix_tout=Radiobutton(fen1,text='Tous',variable=type_vecteur,value=0,command=choix_vecteur)
choix_depla=Radiobutton(fen1,text='Déplacement',variable=type_vecteur,value=1,command=choix_vecteur)
choix_vites=Radiobutton(fen1,text='Vitesse',variable=type_vecteur,value=2,command=choix_vecteur)
choix_accel=Radiobutton(fen1,text='Accélération',variable=type_vecteur,value=3,command=choix_vecteur)
choix_force=Radiobutton(fen1,text='Force',variable=type_vecteur,value=4,command=choix_vecteur)
choix_tout.grid(row=4,column=1)
choix_depla.grid(row=4,column=2)
choix_vites.grid(row=4,column=3)
choix_accel.grid(row=4,column=4)
choix_force.grid(row=4,column=5)

can1.bind("<Button-1>",pointeur)
can1.bind("<Shift-Button-1>",shift_pointeur)
can1.bind('<Button-3>',moins_vect)
can1.bind('<Shift-Button-3>',suppr_vect)
can1.bind('<Control-Button-1>',aff_force)
can1.bind('<Control-Button-3>',ctrl_clic_droit)
can1.bind('<Control-Shift-Button-1>',man_vecteur)
can1.bind('<Control-Shift-Button-3>',man_vecteur_2)

chaine1=Label(fen1)
chaine2=Label(fen1)
chaine1.grid(row=8,column=1,columnspan=5)
chaine2.grid(row=9,column=1,columnspan=5)
chaine3=Label(fen1)
chaine3.grid(row=10,column=1,columnspan=5)
chaine6=Label(fen1)
chaine6.grid(row=5,column=1,columnspan=5)
chaine6.configure(text='----------------- choix de sélection du vecteur -----------------',font="-size 10")
chaine7=Label(fen1)
chaine7.grid(row=6,column=1,columnspan=5)
chaine7.configure(text="Instant courant t = "+str(temps)+' s = '+fonc_temps(temps), font="-size 10")
chaine8=Label(fen1)
chaine8.configure(text="Point sélectionné : instant t = "+str(temps)+' s = '+fonc_temps(temps), font="-size 10")
chaine8.grid(row=7,column=1,columnspan=5)

point_x=[]
point_y=[]
chaine_x=""
chaine_y=""
ch_13=delta_t_exp
chaine14=Label(fen1)
chaine14.grid(row=12,column=1)
chaine14.configure(text="Durée image : "+str(delta_t_exp))
coefpixpoint=0.00090543226  # lumix lycée  2020/12           #0.0019449   # pour mettre à léchelle le pointage
# lumix lycée  2021/02/15 doublebille    #0.0019449   # pour mettre à léchelle le pointage 0.00090543226 pour la bille lanceur lumix 2020/12
transpixpointx=0 # pour décaler le pointage  -0.2 -0.2 en mètres réels  -0.4
transpixpointy=0  # -0.2 Abien  -0.15
chaine16=Label(fen1)
chaine16.grid(row=12, column=2, columnspan=2)
chaine16.configure(text="Long d'un pixel en m : "+str(coefpixpoint))
bou9=Button(fen1, text='Pointage',width=8,command=pointage)
bou9.grid(row=12, column=5)
ch_17=0    # début des points expérimentaux tracés
ch_19=100   # nombre de points expérimentaux tracés
ch_21=len(list_p) # longueur de la liste des points
ch_22=1   # sauts sur les points expérimentaux
vcocher=IntVar(fen1)
casecocher=Checkbutton(fen1,variable=vcocher)
casecocher.grid(row=11,column=4)
casecocher.config(text="Centrage auto")
casecocher.select()

nb_cb_exp=1 # nombre de courbes expérimentales réelles
nb_cb_tra=1 # nombre de courbes expérimentales y compris les valeurs calculées du centre de gravité

ch_9=[0]
ch_10=[0]
for i_cb in range(1,nb_cb_exp+1):
    nom_fic_x='resu_point_mecalab_x_'+str(i_cb)+'.txt'
    nom_fic_y='resu_point_mecalab_y_'+str(i_cb)+'.txt'
    fdx=open(nom_fic_x,'r')
    fdy=open(nom_fic_y,'r')
    lignex=fdx.readline()
    ligney=fdy.readline()
    ch_9.append(lignex[0:-1])
    ch_10.append(ligney[0:-1])
    fdx.close()
    fdy.close()
cond_conf=os.path.isfile('config.txt')
if cond_conf:
    cf=open('config.txt','r')
    nbfic=int(cf.readline())
    entree3.insert(0,str(nbfic))
    cf.close()
else:
    cf=open('config.txt','w')
    nbfic=0
    entree3.insert(0,str(nbfic))
    cf.write('0\nNumero du dernier fichier mcb créé')
    cf.close()

nb_exp=0   # init nombre de points experimentaux
axx=[0]
ayy=[0]
root.mainloop()
root.destroy()