﻿from tkinter import *
from math import *
import wave
import binascii


def quadrillage():
    global dim_x, dim_y, bord_x
    if chkquad.get()==1:
        pasx=40    # pas du cadrillage en pixels
        nx=int(dim_x/pasx)
        ny=int(dim_y/pasx)
        couleur='#39dbf4'
        for i in range (nx):
            can1.create_line(i*pasx+bord_x,0,i*pasx+bord_x,dim_y,fill=couleur)
        for i in range (ny):
            can1.create_line(0,i*pasx+10,dim_x,i*pasx+10,fill=couleur)


class AutoScrollbar(Scrollbar):
    # a scrollbar that hides itself if it's not needed.  only
    # works if you use the grid geometry manager.
    def set(self, lo, hi):
        if float(lo) <= 0.0 and float(hi) >= 1.0:
            # grid_remove is currently missing from Tkinter!
            self.tk.call("grid", "remove", self)
        else:
            self.grid()
        Scrollbar.set(self, lo, hi)

class MaFrame(Frame) :
    def __init__(self, parent) :
        self._vscrollbar = AutoScrollbar(parent)
        self._vscrollbar.grid(row=0, column=1, sticky=NS)
        self._hscrollbar = AutoScrollbar(parent, orient=HORIZONTAL)
        self._hscrollbar.grid(row=1, column=0, sticky=EW)
        self._can = Canvas(parent, bg='white',
                              yscrollcommand=self._vscrollbar.set,
                              xscrollcommand=self._hscrollbar.set)

        self._can.grid(row=0, column=0, sticky=NSEW)
        self._vscrollbar.config(command=self._can.yview)
        self._hscrollbar.config(command=self._can.xview)

        super().__init__(self._can)
        self._can.create_window(0, 0, anchor=NW, window=self, state=NORMAL)
        self.bind('<Configure>', self._actualiserDimension)

    def _actualiserDimension(self, evt) :
        self._can.config(scrollregion=self._can.bbox("all"))

    def grid(self, **dargs) :
        ''' Ne pas grid la Frame '''
        pass

class ComboBox(Frame):
    "Widget composite associant un champ d'entrée avec une boîte de liste"
    def __init__(self, boss, item='',items=[], command='',width=10, listSize=5):
        Frame.__init__(self,boss)
        # constructeur de la classe parente
        # (<boss> est la référence du widget 'maître')
        self.items = items # items à placer dans la boîte de liste
        self.command=command # fonction à invoquer après clic ou <Enter>
        self.item=item  # item entré ou sélectionné

        # Boîte de liste, munie d'un ascenseur (scroll bar) :
        cadreLB=Frame(self)   # cadre pour l'ensemble des 2
        self.bListe=Listbox(cadreLB, height=listSize, width=width-1)
        scrol=Scrollbar(cadreLB, command=self.bListe.yview)
        self.bListe.config(yscrollcommand=scrol.set)
        self.bListe.bind("<ButtonRelease-1>",self.sortieL)
        self.bListe.pack(side=LEFT)
        scrol.pack(expand=YES, fill=Y)
        cadreLB.pack()

        #Remplissage de la boîte de liste avec les items fournis:
        for it in items:
            self.bListe.insert(END, it)

    def sortieL(self, event=None):
        # Extraire de la liste l'item qui a été sélectionné :
        index=self.bListe.curselection()  # renvoie un tuple d'index
        ind0=int(index[0]) # on ne garde que le premier
        self.item=self.items[ind0]
        self.command(ind0)

    def get(self):
        # Renvoyer le dernier item sélectionné dans la boîte de liste
        return self.item

def delete():
    for i in can1.find_all():
        can1.delete(i)

def affiche_onde_01():
    quadrillage()
    for np in range (2*NP,5*NP+1):
        can1.create_line(bord_x+(np-2*NP)*echpx,depla1[np]+ycentre,bord_x+(np-2*NP+1)*echpx,depla1[np+1]+ycentre,width=2, fill='red')

def onde_g():
    if chkg.get()==1 and n>-1:
        for np in range (2*NP,5*NP+1):
            can1.create_line(bord_x+(np-2*NP)*echpx,depla1[np+(n*pasp)%(2*NP)]/2+ycentre,bord_x+(np-2*NP+1)*echpx,depla1[np+1+(n*pasp)%(2*NP)]/2+ycentre,width=2, fill='green')

def onde_d():
    if chkd.get()==1 and n>-1:
        for np in range (2*NP,5*NP+1):
            can1.create_line(bord_x+(np-2*NP)*echpx,depla1[np-(n*pasp)%(2*NP)]/2+ycentre,bord_x+(np-2*NP+1)*echpx,depla1[np+1-(n*pasp)%(2*NP)]/2+ycentre,width=2, fill='green')
def onde_g2():
    if chkg2.get()==1 and n>-1:
        for np in range (2*NP,5*NP+1):
            can1.create_line(bord_x+(np-2*NP)*echpx,depla1[-2*NP+np+(n*pasp)%(2*NP)]/2+ycentre,bord_x+(np-2*NP+1)*echpx,depla1[-2*NP+np+1+(n*pasp)%(2*NP)]/2+ycentre,width=2, fill='red')

def onde_d2():
    if chkd2.get()==1 and n>-1:
        for np in range (2*NP,5*NP+1):
            can1.create_line(bord_x+(np-2*NP)*echpx,depla1[2*NP+np-(n*pasp)%(2*NP)]/2+ycentre,bord_x+(np-2*NP+1)*echpx,depla1[2*NP+np+1-(n*pasp)%(2*NP)]/2+ycentre,width=2, fill='red')

def onde_gr():
    if chkgr.get()==1 and n>-1:
        for np in range (2*NP,5*NP+1):
            can1.create_line(bord_x+(np-2*NP)*echpx,-depla1[6*NP-np+(n*pasp)%(2*NP)]/2+ycentre,bord_x+(np-2*NP+1)*echpx,-depla1[6*NP-np-1+(n*pasp)%(2*NP)]/2+ycentre,width=2, fill='blue')

def onde_dr():
    if chkdr.get()==1 and n>-1:
        for np in range (2*NP,5*NP+1):
          #  can1.create_line(bord_x+(np-2*NP)*echpx,-depla1[NP-1-np-(n*pasp)%(2*NP)]/2+ycentre,bord_x+(np-2*NP+1)*echpx,-depla1[NP-1-np-1-(n*pasp)%(2*NP)]/2+ycentre,width=2, fill='blue')
           can1.create_line(bord_x+(np-2*NP)*echpx,-depla1[NP-np-2-(n*pasp)%(2*NP)]/2+ycentre,bord_x+(np-2*NP+1)*echpx,-depla1[NP-np-3-(n*pasp)%(2*NP)]/2+ycentre,width=2, fill='blue')

def reinit():
    global n
    stop()
    n=-1
    resu=chk1.get()
    delete()
    if resu == 1:
        affiche_onde_01()


def onde_init():
    resu=chk1.get()
    delete()
    if resu==1:
        affiche_onde_01()
def avant():
    global n, pasp, pas2
    #pasp=pasp2
    n=n+1
    delete()
    quadrillage()
    onde_g()
    onde_d()
    onde_dr()
    onde_gr()
    onde_d2()
    onde_g2()
    oval8=can1.create_oval(bord_x+NP*echpx-2,ycentre-2,bord_x+NP*echpx+2,ycentre+2, width=2, fill='black')
    oval9=can1.create_oval(bord_x+2*NP*echpx-2,ycentre-2,bord_x+2*NP*echpx+2,ycentre+2, width=2, fill='black')
    total()

  #  oval5=can1.create_oval(bord_x+NP*echpx-2+((n*pasp)%(2*NP))*echpx,ycentre-2,bord_x+NP*echpx+2+((n*pasp)%(2*NP))*echpx,ycentre+2, width=2, fill='black')
  #  oval6=can1.create_oval(bord_x+2*NP*echpx-2+((n*pasp)%(2*NP))*echpx,ycentre-2,bord_x+2*NP*echpx+2+((n*pasp)%(2*NP))*echpx,ycentre+2, width=2, fill='black')
  #  oval3=can1.create_oval(bord_x+NP*echpx-2-((n*pasp)%(2*NP))*echpx,ycentre-2,bord_x+NP*echpx+2-((n*pasp)%(2*NP))*echpx,ycentre+2, width=2, fill='black')
  #  oval4=can1.create_oval(bord_x+2*NP*echpx-2-((n*pasp)%(2*NP))*echpx,ycentre-2,bord_x+2*NP*echpx+2-((n*pasp)%(2*NP))*echpx,ycentre+2, width=2, fill='black')


def arriere():
    global n, pasp, pasp2
    if n>0:
        #pasp=pasp2
        n=n-1
        delete()
        quadrillage()
        onde_g()
        onde_d()
        onde_dr()
        onde_gr()
        onde_d2()
        onde_g2()
        oval10=can1.create_oval(bord_x+NP*echpx-2,ycentre-2,bord_x+NP*echpx+2,ycentre+2, width=2, fill='black')
        oval11=can1.create_oval(bord_x+2*NP*echpx-2,ycentre-2,bord_x+2*NP*echpx+2,ycentre+2, width=2, fill='black')
        total()

def total():
    global n, pasp, depla1,NP, ycentre
    tot=[]
    if chktot.get()==1:
      #  print('dans total')
        for np in range(NP+2):
            tot.append(0)
        if chkgt.get()==1:
            for np in range(NP+1):
                tot[np]=tot[np]+depla1[np+(n*pasp)%(2*NP)+3*NP]  # onde gauche
              #  print('tot[np] = ',tot[np])
        if chkdt.get()==1:
            for np in range(NP+1):
                tot[np]=tot[np]+depla1[np-(n*pasp)%(2*NP)+3*NP]  # onde droite
        if chkgrt.get()==1:
            for np in range(NP+1):
                tot[np]=tot[np]-depla1[6*NP-np+(n*pasp)%(2*NP)-3*NP]  # onde réfléchie gauche
        if chkdrt.get()==1:
            for np in range(NP+1):
                tot[np]=tot[np]-depla1[NP-2-np-(n*pasp)%(2*NP)-3*NP] # onde réfléchie droite  NP-1-np
        if chkg2t.get()==1:
            for np in range(NP+1):
                tot[np]=tot[np]+depla1[-2*NP+np+(n*pasp)%(2*NP)+3*NP]  # 2ème réflexion gauche
        if chkd2t.get()==1:
            for np in range(NP+1):
                tot[np]=tot[np]+depla1[2*NP+np-(n*pasp)%(2*NP)+3*NP]   #2ème réflexion droite
        for np in range(NP):
       # print('tot[np] = ',tot[np])
            can1.create_line(bord_x+(np+NP)*echpx,tot[np]/2+ycentre,bord_x+(np+NP+1)*echpx,tot[np+1]/2+ycentre,width=2, fill='black')
  #  print('tot[np] = ',tot[NP])

def anim():
    global pasp, pasp3,pasp2, n,n1,n2
    avant()
    n1=n1+1
    if drapeau_01>0:
        root.after(1,anim)  #10
    else:
        pasp=pasp2
        n=n2+int(n1*pasp3/pasp)  # pour rester au meme point


def anim_deb():
    global drapeau_01, pasp, pasp2, pasp3, n,n1,n2
    pasp2=pasp
    pasp=pasp3
    drapeau_01=1
    n1=0
    if n<0:
        n=0
    n2=n
    n=int(n*pasp2/pasp3)
    anim()

def stop():
    global drapeau_01, pasp, pasp2
    drapeau_01=0
    #pasp=pasp2

def son():
    global NP, NP3, NP2
    print("Création d'un fichier audio au format WAV (PCM 16 bits stéréo 44100 Hz)")

    NomFichier = 'son2.wav'
    Monson = wave.open(NomFichier,'w') # instanciation de l'objet Monson

    nbCanal = 2    # stéreo
    nbOctet = 2    # taille d'un échantillon : 1 octet = 8 bits
    fech = 44100   # fréquence d'échantillonnage

    frequenceG = float(entree1.get())
    frequenceD=frequenceG
#frequenceD = float(input('Fréquence du son du canal de droite (Hz) ? '))
#niveauG = float(input('Niveau du son du canal de gauche (0 à 1) ? '))
    niveauG = 1.0 # entre 0 et 1

    niveauD = 1.0
    duree = float(entree2.get())

    nbEchantillon = int(duree*fech)
#print("Nombre d'échantillons :",nbEchantillon)

    parametres = (nbCanal,nbOctet,fech,nbEchantillon,'NONE','not compressed')# tuple
    Monson.setparams(parametres)    # création de l'en-tête (44 octets)

# niveau max dans l'onde positive : +1 -> 255 (0xFF)
# niveau max dans l'onde négative : -1 ->   0 (0x00)
# niveau sonore nul :                0 -> 127.5 (0x80 en valeur arrondi)

    amplitudeG = 32760*niveauG   # 127.5   32768
    amplitudeD = 32760*niveauD   #127.5
    NP3=int(fech/frequenceG/2)
    depla2=[]
    depla2.append(0)             # valeurs interpolées à la fréquence d'échantillonnage
    for np3 in range(1,NP3):
        xnp=np3*NP/NP3
        np=int(xnp)
        res=(xnp-np)*(depla_init[np+1]-depla_init[np])+depla_init[np]
        depla2.append(res)
    depla2.append(0)  # en NP3
    depla3=[]
    for np3 in range(3*NP3):
        depla3.append(0)
    for np3 in range(NP3+1):
        depla3.append(depla2[np3])
    for np3 in range(3*NP3+1):
        depla3.append(0)
    son_force_01=[]
    np=NP3-1    # on prend le signal sur l'avant dernier point de la corde
    for np3 in range(nbEchantillon):
        totson=depla3[np+((np3)%(2*NP3))+3*NP3]\
        +depla3[np-((np3)%(2*NP3))+3*NP3]-depla3[6*NP3-np+(np3)%(2*NP3)-3*NP3]\
        -depla3[NP3-2-np-((np3)%(2*NP3))-3*NP3]\
        +depla3[-2*NP3+np+((np3)%(2*NP3))+3*NP3]\
        +depla3[2*NP3+np-((np3)%(2*NP3))+3*NP3]
        son_force_01.append(totson)
    print('Veuillez patienter...')
       # for i_son in range (100000):
       #     print('son_force= ',son_force_01[i_son])
    max_son=max(son_force_01)
    min_son=min(son_force_01)
    print('max_son = ',max_son)
    print('min_son = ',min_son)
    maxi_son=max(abs(max_son),abs(min_son))
       # N_per=int(fech/frequenceG)
       # print('N_per = ',N_per)
        #N_c=len(son_force_01)
        #print('Longueur son_force_01 = ',N_c)
    for i in range(0,nbEchantillon):
            #n_i=int((i%N_per)*N_c/N_per)
           # print('indice ecrit_fic = ',n_i)
        resu_son=int(amplitudeG/maxi_son*son_force_01[i])
            # canal gauche
            # 127.5 + 0.5 pour arrondir à l'entier le plus proche
        valG = wave.struct.pack('h',resu_son)
            # canal droit
        valD = wave.struct.pack('h',resu_son)
        Monson.writeframes(valG + valD) # écriture frame
    Monson.close()












root=Tk()
root.grid_rowconfigure(0, weight=1)
root.grid_columnconfigure(0, weight=1)
ws = root.winfo_screenwidth() # width of the screen
hs = root.winfo_screenheight() # height of the screen
fen1 = MaFrame(root)
#root.geometry("1500x850+-400+0")
#root.geometry("1500x850+-400+0")
root.geometry("%dx%d+%d+%d" % (ws-45, hs-90, 0, 0))


# variables globales
pi_314=acos(-1)
dim_x=1820       # dimensions de la fenêtre  800
dim_y=500
bord_x=10
can1=Canvas(fen1,bg='dark grey',height=dim_y,width=dim_x)
can1.grid(column=0,row=0,columnspan=25)
n=-1 # pas de temps
n1=0   # pas animation
n2=0
pasp3=1
pasp2=1
drapeau_01=0
NP2=100
NP3=100  # pour le son
#########################################################
NP = 100 #   nombre de points géométriques pour décire l'onde initiale
depla_init=[]
x_pincement=4/5  # position du pincement de la corde
amplitude=200
pasp=5          # nombre de pixels pour un déplacement élémentaire

# son sinusoidal
############################################################
echpx=int((dim_x-2*bord_x)/1.0/3/NP) # nombre de pixels pour un segment de 0 à NP
ycentre=int(dim_y/2)
ip=int(NP*x_pincement)
a1=amplitude/NP/x_pincement
a2=amplitude/(ip-NP)
b2=amplitude-a2*ip
depla_init.append(0)
for np in range(1,NP):
    xresu=amplitude*sin(np*pi/NP)
    depla_init.append(xresu)
depla_init.append(0)
depla1=[]
for np in range(3*NP):
    depla1.append(0)
for np in range(NP+1):
    depla1.append(depla_init[np])
for np in range(3*NP+1):
    depla1.append(0)
#affiche_onde_01()
chk1=IntVar()
bouch1=Checkbutton(fen1, text='Corde',variable=chk1, command=onde_init)
bouch1.grid(row=1,column=0)
bouch1.select()
lbl1=Label(fen1)
lbl1.grid(row=1,column=1,columnspan=2)
lbl1.configure(text="Visualisation", font="-size 10")
lbl2=Label(fen1)
lbl2.grid(row=1,column=5,columnspan=2)
lbl2.configure(text="Calcul onde totale", font="-size 10")

chkg=IntVar()
bouch2=Checkbutton(fen1, text='Onde <-- ',variable=chkg, command=onde_g)
bouch2.grid(row=2,column=1)
bouch2.select()
chkd=IntVar()
bouch3=Checkbutton(fen1, text='Onde --> ',variable=chkd, command=onde_d)
bouch3.grid(row=2,column=2)
bouch3.select()
chkgr=IntVar()
bouch4=Checkbutton(fen1, text='Onde --> Ref ',variable=chkgr, command=onde_gr)
bouch4.grid(row=3,column=1)
bouch4.select()
chkdr=IntVar()
bouch5=Checkbutton(fen1, text='Onde <-- Ref',variable=chkdr, command=onde_dr)
bouch5.grid(row=3,column=2)
bouch5.select()
chkg2=IntVar()
bouch6=Checkbutton(fen1, text='Onde <-- Ref 2 ',variable=chkg2, command=onde_g2)
bouch6.grid(row=4,column=1)
bouch6.select()
chkd2=IntVar()
bouch7=Checkbutton(fen1, text='Onde --> Ref 2',variable=chkd2, command=onde_d2)
bouch7.grid(row=4,column=2)
bouch7.select()

chkgt=IntVar()
bouch2t=Checkbutton(fen1, text='Onde <-- ',variable=chkgt)
bouch2t.grid(row=2,column=5)
bouch2t.select()
chkdt=IntVar()
bouch3t=Checkbutton(fen1, text='Onde --> ',variable=chkdt)
bouch3t.grid(row=2,column=6)
bouch3t.select()
chkgrt=IntVar()
bouch4t=Checkbutton(fen1, text='Onde --> Ref ',variable=chkgrt)
bouch4t.grid(row=3,column=5)
bouch4t.select()
chkdrt=IntVar()
bouch5t=Checkbutton(fen1, text='Onde <-- Ref',variable=chkdrt)
bouch5t.grid(row=3,column=6)
bouch5t.select()
chkg2t=IntVar()
bouch6t=Checkbutton(fen1, text='Onde <-- Ref 2 ',variable=chkg2t)
bouch6t.grid(row=4,column=5)
bouch6t.select()
chkd2t=IntVar()
bouch7t=Checkbutton(fen1, text='Onde --> Ref 2',variable=chkd2t)
bouch7t.grid(row=4,column=6)
bouch7t.select()
chktot=IntVar()
bouchtot=Checkbutton(fen1, text='Visualisation onde totale',variable=chktot, command=total)
bouchtot.grid(row=1,column=8)
bouchtot.select()
chkquad=IntVar()
bouchquad=Checkbutton(fen1, text='Quadrillage',variable=chkquad, command=quadrillage)
bouchquad.grid(row=4,column=8)
bouchquad.select()
affiche_onde_01()

bou1=Button(fen1, text='Incrément',width=8,command=avant)
bou1.grid(row=1, column=9)
bou2=Button(fen1, text='Décrément',width=8,command=arriere)
bou2.grid(row=1, column=10)
bou3=Button(fen1, text='Animation',width=8,command=anim_deb)
bou3.grid(row=1, column=11)
bou4=Button(fen1, text='Stop',width=8,command=stop)
bou4.grid(row=1, column=12)
bou5=Button(fen1, text='Fichier son',width=8,command=son)
bou5.grid(row=1, column=13)
bou6=Button(fen1, text='Réinitialiser',width=8,command=reinit)
bou6.grid(row=3, column=11)

entree1=Entry(fen1,width=5)
entree1.grid(row=2,column=13)
entree2=Entry(fen1,width=5)
entree2.grid(row=3,column=13)
entree1.insert(0,'110')
entree2.insert(0,'5')
lbl3=Label(fen1)
lbl3.grid(row=2,column=14,columnspan=1)
lbl3.configure(text="Fréquence (Hz)", font="-size 10")
lbl4=Label(fen1)
lbl4.grid(row=3,column=14,columnspan=1)
lbl4.configure(text="Durée (s)", font="-size 10")


bou0=Button(fen1,text='Quitter', width=8,command=fen1.quit)
bou0.grid(row=4,column=0)
#vcocher=IntVar(fen1)
#casecocher=Checkbutton(fen1,variable=vcocher)
#casecocher.grid(row=11,column=4)
#casecocher.config(text="Centrage auto")
#casecocher.select()
oval1=can1.create_oval(bord_x+NP*echpx-2,ycentre-2,bord_x+NP*echpx+2,ycentre+2, width=2, fill='black')
oval2=can1.create_oval(bord_x+2*NP*echpx-2,ycentre-2,bord_x+2*NP*echpx+2,ycentre+2, width=2, fill='black')



root.mainloop()
root.destroy()