﻿import math
import cmath



adapt=50  # impedance recherchee pour la ligne en ohm
Z0=adapt
R0=50     # résistance en fin de ligne  en ohm
X0=0     # réactance en fin de ligne  en ohm
vitesse=299792458        # vitesse de propagation de l'onde en m.s-1
#L:=1.6678204759907602e-7;  # Henry par mètre
L = Z0 / vitesse             # inductance linéique pour obtenir Z0 et vitesse

#C:=6.67128190396304e-11;   # Farad par mètre
C = 1 / (Z0*vitesse )      # capacité linéique pour obtenir Z0 et vitesse
freq=1e9                 # fréquence signal en Hertz (1 GHz)
omega_freq=2*math.pi*freq     # pulsation
lambda_freq=vitesse/freq  # longueur d'onde en m
long=lambda_freq/4            # longueur de la ligne  (ici, quart d'onde)
nb_cel=4                   # nombre de cellules RC pour représenter la ligne
R1=0                # pertes dans la bobine en ohm
X1=L*long/nb_cel*omega_freq    #  impedance unitaire de chaque bobine en Ohm
R2=0   # pertes dans le condensateur en ohm
X2=-1/(C*long/nb_cel*omega_freq)   # impedance de chaque condensateur en Ohm


# calcul des coefficients de la matrice homographique ( a * x + b )/(c * x + d)
a_r=R1+R2  # _r : reel  _i : imaginaire
a_i=X1+X2
b_r=R1*R2-X1*X2
b_i=R1*X2+R2*X1
c_r=1
c_i=0
d_r=R2
d_i=X2
a=complex(a_r,a_i)
b=complex(b_r,b_i)
c=complex(c_r,c_i)
d=complex(d_r,d_i)

# calcul valeurs propres
lambda_1=(d+a+cmath.sqrt(a**2-2*d*a+4*c*b+d**2))/2
lambda_2=(d+a-cmath.sqrt(a**2-2*d*a+4*c*b+d**2))/2


#print("lambda 1 = ",lambda_1,"lambda 2 = ",lambda_2)

# matice des vecteurs propres
al=2*b/(d-a+cmath.sqrt(a**2-2*d*a+4*c*b+d**2))
be=2*b/(d-a-cmath.sqrt(a**2-2*d*a+4*c*b+d**2))
ga=1
de=1

# calcul de l'inverse de cette matrice
det=al*de-be*ga
alp=de/det
bet=-be/det
gam=-ga/det
delt=al/det

# calcul de z(nb_cel)
u0=complex(R0,X0)
v0=(alp*u0+bet)/(gam*u0+delt)    # passage de un à vn
rapport=lambda_1/lambda_2
vn=v0*(rapport**nb_cel)         # vn est une suite géométrique
z=(bet-vn*delt)/(gam*vn-alp)    # passage de vn à un

print("Impédance vue en début de ligne = ",z)
