﻿# calcul de circuits par équivalent série ou parallèle
from math import pi


def para(z1,z2):            # calcul de l'impédance équivalente pour
    return z1*z2/(z1+z2)    # 2 impédances en dérivation


# données numériques :
frequence=50      # en hertz
om=2*pi*frequence  # pulsation


l1=0.2              # inductance en henry de la bobine
c1=100e-6          # capacité du condensateur en farad
z2=complex(100,100)  # impédance complexe  (résistance ohm , réactance ohm )
z3=complex(200,50)
r4=20               #  résistance en ohm
z5=complex(0,-1/(c1*om))   # impédance du condensateur
z6=complex(0,l1*om)  # impédance de la bobine


# calcul des impédances équivalentes (série, parallèle) :

z1=para(para(z2,z3),z6)+r4+z5     # z2, z3, l1 en parallèle, le tout en séraie avec r4 et c1

# calcul des courants et des tensions :

e=12     # tension du générateur en volt
i1=e/z1           # intensité en ampère
e2=e-i1*(r4+z5)
i2=e2/z2
i3=e2/z3
i6=e2/z6
e3=i1*z5        # tension aux borne du condensateur

# affichage des résultats

print("z6=",z6)
print("z5=",z5)
print("z2=",z2)
print("i1=",i1)
print("i2=",i2)
print("i3=",i3)
print("i6=",i6)
print("i2+i3+i6=",i2+i3+i6)
print("e3=",e3)
print("module de e3 = ",abs(e3))

