﻿# Calcul des neq  avancements finaux de neq équilibres chimiques

# titrage d'un acide faible par une base forte

import math
import matplotlib.pyplot as plt


TINY = 1.0e-20


def ludcmp(a,n,indx,d):
    # numerical recipies ed 2 C p 46
    vv=[]
    for i in range(0,n+1):
        vv.append(0)  # les indices utilisés vont de 1 à n . On préremplit le tableau
    d=1.0        # no row interchanges yet
    for i in range(1,n+1): #(i=1;i<=n;i++)    // loop over rows to get the implicit scaling information
        big=0.0
        for j in range (1,n+1):   #(j=1;j<=n;j++)
            temp=abs(a[i][j])
            if temp>big:
                big=temp
        if big==0.0:
            print("matrice singuliere in ludcmp()")
            return
        vv[i]=1.0/big   # ; // save the scaling
    for j in range(1,n+1):   #(j=1;j<=n;j++)  // this is the loop overcolumns of Crout's method
        for i in range(1,j):   #(i=1;i<j;i++)   // equation 2.3.12 except for i=javascript
            summ=a[i][j]                           # sum renommé summ
            for k in range(1,i): #(k=1;k<i;k++)
                summ=summ-a[i][k]*a[k][j]
            a[i][j]=summ
        big=0.0    #   // initialize for the surch for largest pivot element
        for i in range(j,n+1):  #(i=j;i<=n;i++)    // this is i=j of equation 2.3.12 and i=j+1...N of equation 2.3.13
            summ=a[i][j]
            for k in range(1,j):   #(k=1;k<j;k++)
                summ=summ-a[i][k]*a[k][j]
            a[i][j]=summ
            dum=vv[i]*abs(summ)

            if dum>=big :
                #// is the figure of merit for the pivot better than the best so far ?
                big=dum
                imax=i
        if j!=imax :   #  // do we need to interchange rows ?
            for k in range(1,n+1):   #(k=1;k<=n;k++)
                #// yes, do so ...
                dum=a[imax][k];
                a[imax][k]=a[j][k];
                a[j][k]=dum
            d=-d  # //and change the parity of dQ/dt
            vv[imax]=vv[j]  #   // also interchange the scale factor
        indx[j]=imax
        if a[j][j]==0 :
            a[j][j]=TINY #  // marice singuliere
        if j != n :
            dum=1.0/(a[j][j])
            for i in range(j+1,n+1): #(i=j+1;i<=n;i++)
                a[i][j]=a[i][j]*dum

# fin de la fonction   ludcmp(a,n,indx,d)


def lubksb(a,n,indx,b):
    ii=0
    for i in range(1,n+1):   #(i=1;i<=n;i++)
        ip=indx[i]
        summ=b[ip]
        b[ip]=b[i]
        if ii!=0:
            for j in range(ii,i):  #(j=ii;j<=i-1;j++)
                summ=summ-a[i][j]*b[j]
        elif summ!=0 :
            ii=i
        b[i]=summ;
    for i in range (n,0,-1):  #    (i=n;i>=1;i--)  *************************A VERIFIER
        summ=b[i]
        for j in range(i+1,n+1): #  (j=i+1;j<=n;j++)
            summ=summ-a[i][j]*b[j]
        b[i]=summ/a[i][i]


#  Fin fonction lubksb(a,n,indx,b)

def f1(xx):
    global n0A,n0B,Vtot
    return Ka1*n0A/Vtot-Ka1*xx[1]/Vtot-xx[1]*xx[1]/Vtot/Vtot-xx[1]*xx[2]/Vtot/Vtot  #  Quotient de réaction du premier équilibre
def f2(xx):
    global n0A,n0B,Vtot,C2,V2
    return Ke-xx[1]*xx[2]/Vtot/Vtot-xx[2]*xx[2]/Vtot/Vtot-xx[1]*C2*V2/Vtot/Vtot-xx[2]*C2*V2/Vtot/Vtot                                                    # Quotient de réaction d'autodissociation de l'eau
def d1f1(xx):
    global n0A,n0B,Vtot,C2,V2
    return -Ka1/Vtot-2*xx[1]/Vtot/Vtot-xx[2]/Vtot/Vtot   # dérivée eq 1 par rapport à x1
def d2f1(xx):
    global n0A,n0B,Vtot,C2,V2
    return -xx[1]/Vtot/Vtot
def d1f2(xx):
    global n0A,n0B,Vtot,C2,V2
    return -xx[2]/Vtot/Vtot-C2*V2/Vtot/Vtot
def d2f2(xx):
    global n0A,n0B,Vtot,C2,V2
    return -2*xx[2]/Vtot/Vtot-xx[1]/Vtot/Vtot-C2*V2/Vtot/Vtot


precision=1.0e-10
#precision=1.0e-7
def calcul_iteratif():
    global xx,xx2,n0A,n0B,Vtot
    nit=0
    while (abs(xx[1]-xx2[1])>precision)or(abs(xx[2]-xx2[2])>precision):
        a[1][1]=d1f1(xx)
        a[1][2]=d2f1(xx)
        a[2][1]=d1f2(xx)
        a[2][2]=d2f2(xx)
        b[1]=-f1(xx)
        b[2]=-f2(xx)
        d=0                                      # = 1 si le nombre de permutations est pair, -1 sinon
        ludcmp(a,neq,indx,d)  # résolution du système linéaire
        lubksb(a,neq,indx,b)
        nit=nit+1
        for i in range(neq+1):
            xx2[i]=xx[i]
            xx[i]=b[i]+xx[i]

resu_x=[]
resu_y1=[]
resu_y2=[]
resu_pH=[]
neq=2   # nombre d'équilivbres == nombre d'avancements xx[i] à déterminer
xx=[]    #
xx2=[]
for i in range(neq+1):
    xx.append(0.1)
    xx2.append(0)
pKa1=4.76
Ke=10**(-14)   # produit ionique de l'eau
Ka1=10**(-pKa1)
V1=0.025   # volume de la solution en L à titrer
C1=1.0e-1  # concentration solution à titrer
n0A=C1*V1
#alp=0.5   # fraction d'acide HA introduite  (1-alp) est la fraction de base A- introduite
C2=25.0e-2 #  est la concentration en mol . L-1 totale en espèce A (sous forme AH ou A-) titrante soude
V2=0      # volume versé de solution titrante
V2max=0.02 # volume de solution titrante max en L
couleur=['#FF8000','#9443e3','#4366e3']
a=[]
for i in range(neq+2):
    a.append(0)
for i in range(neq+2):
    a[i]=[]
    for j in range(neq+2):
        a[i].append(0)
b=[]
for i in range(neq+2):
    b.append(0)
    indx=[]
for i in range (neq+2):
    indx.append(0)


nbpoints=200
for ialp in range(nbpoints+1):
    V2=ialp/nbpoints*V2max
    Vtot=V1+V2
    for k in range(neq+1):
        xx[k]=0.1
        xx2[k]=0.0
    calcul_iteratif()
    resu_x.append(V2)
    resu_y1.append(xx[1])
    resu_y2.append(xx[2])
    pH = -math.log10((xx[1]+xx[2])/Vtot)
    resu_pH.append(pH)
    if ialp==nbpoints/2+1 :
        print("pH à l'équivalence = ",pH)
    if ialp==nbpoints/4+1 :
        print("pH à la demi-équivalence = ",pH)
plt.plot(resu_x,resu_pH,couleur[0], label = "C1 = "+str(C1)+" mol.L-1  V1 = "+str(V1)+" L  C2 = "+str(C2)+" mol.L-1 (pK = "+str(pKa1)+" )")
plt.xlabel("Volume V2 (L) (Veq = "+str(C1/C2*V1)+" L)")
plt.ylabel("pH")
plt.legend()
plt.show()
