﻿# Calcul des neq  avancements finaux de neq équilibres chimiques
#
# mélange AH et A- en proportion 0<=alp<=1

import math
import matplotlib.pyplot as plt
#var indx=new Array();  // pour la resolution num recipies p 46
#var d;     // idem
#var TINY = 1.0e-20;   // idem
#var b = new Array();  // idem

TINY = 1.0e-20


def ludcmp(a,n,indx,d):
    # numerical recipies ed 2 C p 46
    vv=[]
    for i in range(0,n+1):
        vv.append(0)  # les indices utilisés vont de 1 à n . On préremplit le tableau
    d=1.0        # no row interchanges yet
    for i in range(1,n+1): #(i=1;i<=n;i++)    // loop over rows to get the implicit scaling information
        big=0.0
        for j in range (1,n+1):   #(j=1;j<=n;j++)
            temp=abs(a[i][j])
            if temp>big:
                big=temp
        if big==0.0:
            print("matrice singuliere in ludcmp()")
            return
        vv[i]=1.0/big   # ; // save the scaling
    for j in range(1,n+1):   #(j=1;j<=n;j++)  // this is the loop overcolumns of Crout's method
        for i in range(1,j):   #(i=1;i<j;i++)   // equation 2.3.12 except for i=javascript
            summ=a[i][j]                           # sum renommé summ
            for k in range(1,i): #(k=1;k<i;k++)
                summ=summ-a[i][k]*a[k][j]
            a[i][j]=summ
        big=0.0    #   // initialize for the surch for largest pivot element
        for i in range(j,n+1):  #(i=j;i<=n;i++)    // this is i=j of equation 2.3.12 and i=j+1...N of equation 2.3.13
            summ=a[i][j]
            for k in range(1,j):   #(k=1;k<j;k++)
                summ=summ-a[i][k]*a[k][j]
            a[i][j]=summ
            dum=vv[i]*abs(summ)

            if dum>=big :
                #// is the figure of merit for the pivot better than the best so far ?
                big=dum
                imax=i
        if j!=imax :   #  // do we need to interchange rows ?
            for k in range(1,n+1):   #(k=1;k<=n;k++)
                #// yes, do so ...
                dum=a[imax][k];
                a[imax][k]=a[j][k];
                a[j][k]=dum
            d=-d  # //and change the parity of dQ/dt
            vv[imax]=vv[j]  #   // also interchange the scale factor
        indx[j]=imax
        if a[j][j]==0 :
            a[j][j]=TINY #  // marice singuliere
        if j != n :
            dum=1.0/(a[j][j])
            for i in range(j+1,n+1): #(i=j+1;i<=n;i++)
                a[i][j]=a[i][j]*dum

# fin de la fonction   ludcmp(a,n,indx,d)


def lubksb(a,n,indx,b):
    ii=0
    for i in range(1,n+1):   #(i=1;i<=n;i++)
        ip=indx[i]
        summ=b[ip]
        b[ip]=b[i]
        if ii!=0:
            for j in range(ii,i):  #(j=ii;j<=i-1;j++)
                summ=summ-a[i][j]*b[j]
        elif summ!=0 :
            ii=i
        b[i]=summ;
    for i in range (n,0,-1):  #    (i=n;i>=1;i--)  *************************A VERIFIER
        summ=b[i]
        for j in range(i+1,n+1): #  (j=i+1;j<=n;j++)
            summ=summ-a[i][j]*b[j]
        b[i]=summ/a[i][i]


#  Fin fonction lubksb(a,n,indx,b)

def f1(xx):
    global n0A,n0B
    return Ka1*n0A/V-Ka1*xx[1]/V-n0B*xx[1]/V/V-n0B*xx[2]/V/V-xx[1]*xx[1]/V/V-xx[1]*xx[2]/V/V  #  Quotient de réaction du premier équilibre
def f2(xx):
    global n0A,n0B
    return Ke-xx[1]*xx[2]/V/V-xx[2]*xx[2]/V/V                                                    # Quotient de réaction d'autodissociation de l'eau
def d1f1(xx):
    global n0A,n0B
    return -Ka1/V-n0B/V/V-2*xx[1]/V/V-xx[2]/V/V   # dérivée eq 1 par rapport à x1
def d2f1(xx):
    global n0A,n0B
    return -n0B/V/V-xx[1]/V/V
def d1f2(xx):
    global n0A,n0B
    return -xx[2]/V/V
def d2f2(xx):
    global n0A,n0B
    return -2*xx[2]/V/V-xx[1]/V/V


precision=1.0e-10
def calcul_iteratif():
    global xx,xx2,n0A,n0B
    nit=0
    while (abs(xx[1]-xx2[1])>precision)or(abs(xx[2]-xx2[2])>precision):
        a[1][1]=d1f1(xx)
        a[1][2]=d2f1(xx)
        a[2][1]=d1f2(xx)
        a[2][2]=d2f2(xx)
        b[1]=-f1(xx)
        b[2]=-f2(xx)
        d=0                                      # = 1 sile nombre de permutations est pair, -1 sinon
        ludcmp(a,neq,indx,d)   # resolution du système linéaire
        lubksb(a,neq,indx,b)   # idem
        nit=nit+1
        for i in range(neq+1):
            xx2[i]=xx[i]
            xx[i]=b[i]+xx[i]

resu_x=[]
resu_y1=[]
resu_y2=[]
resu_pH=[]
neq=2   # nombre d'équilivbres == nombre d'avancements xx[i] à déterminer
xx=[]    #
xx2=[]
for i in range(neq+1):
    xx.append(0.1)
    xx2.append(0)
pKa1=4.76
Ke=10**(-14)   # produit ionique de l'eau
Ka1=10**(-pKa1)
V=0.250   # volume de la solution en L
alp=0.5   # fraction d'acide HA introduite  (1-alp) est la fraction de base A- introduite
C0=0.1 #  est la concentration en mol . L-1 totale en espèce A (sous forme AH ou A-)
couleur=['#FF8000','#9443e3','#4366e3']
a=[]
for i in range(neq+2):
    a.append(0)
for i in range(neq+2):
    a[i]=[]
    for j in range(neq+2):
        a[i].append(0)
b=[]
for i in range(neq+2):
    b.append(0)
    indx=[]
for i in range (neq+2):
    indx.append(0)


nbpoints=200
for ialp in range(nbpoints+1):
    alp=ialp/nbpoints
    n0A=C0*V*alp   # quantité de matière d'acide AH introduite
    n0B=C0*V*(1-alp)  #  quantité de matière de base A- introduite
    for k in range(neq+1):
        xx[k]=0.1
        xx2[k]=0.0
    calcul_iteratif()
    resu_x.append(alp)
    resu_y1.append(xx[1])
    resu_y2.append(xx[2])
    pH = -math.log10((xx[1]+xx[2])/V)
  #  print("pH = ",pH)
    resu_pH.append(pH)
plt.plot(resu_x,resu_pH,couleur[0], label = "C = "+str(C0)+"mol.L-1  V = "+str(V)+" L (pK = "+str(pKa1)+" )")
plt.xlabel("Fraction AH / (A- + AH)")
plt.ylabel("pH")
plt.legend()
plt.show()
