﻿
# titrage d'un acide fort par une base forte

import math
import matplotlib.pyplot as plt


resu_t=[]
resu_c1_1=[]
resu_c1_2=[]
resu_c2_1=[]
resu_c2_2=[]
resu_exp=[]

t1=1.0       # temps de demi_réaction en seconde
tfinal=500.0
k1=math.log(2)/t1   # constante de cinetique
k2=0.1
k3=0.3
c1_0=0.1       # concentration initiale en espèce 1 en mol.L-1
c1_1=c1_0      # valeur à l'instant t
c1_2=c1_0
c2_0=0.0001
c2_1=c2_0
c2_2=c2_0
delta_t=0.01   # pas de temps en seconde
resu_c1_1.append(c1_0)
resu_c1_2.append(c1_0)
resu_c2_1.append(c2_0)
resu_c2_2.append(c2_0)
resu_exp.append(c1_0)
t=0
resu_t.append(t)
delta_x=0

def vitesse1():
    c=max(c1_1,0)
    return k1*(c**0.5)*k2*c2_1

def vitesse2():
    c=max(c1_2,0)
    return k1*c*k3*c2_2


def calc_exp(t):
    return c1_0*math.exp(-k1*t)

couleur1='#FF8000'
couleur2='#FF80FF'
couleur3="#0000FF"
couleur4="#00FF00"

nbpoints=int(tfinal/delta_t)
for i in range(nbpoints+1):
    t=t+delta_t
    resu_t.append(t)
    delta_x1=vitesse1()*delta_t
    c1_1=c1_1-delta_x1
    c2_1=c2_1+delta_x1
    resu_c1_1.append(c1_1)
    resu_c2_1.append(c2_1)
    delta_x2=vitesse2()*delta_t
    c1_2=c1_2-delta_x2
    c2_2=c2_2+delta_x2
    resu_c1_2.append(c1_2)
    resu_c2_2.append(c2_2)



    resu_exp.append(calc_exp(t))

#plt.plot(resu_t,resu_exp,couleur2,label="Exponentielle")
plt.plot(resu_t,resu_c1_1,couleur1, label = "c1_1 ordre 1/2 react ordre 1 produit (Euler)")
plt.plot(resu_t,resu_c2_1,couleur2, label = "c2_1  (Euler)")
plt.plot(resu_t,resu_c1_2,couleur3, label = "c1_2 ordre 1 react ordre 1 produit (Euler)")
plt.plot(resu_t,resu_c2_2,couleur4, label = "c2_2  (Euler)")

#plt.plot(resu_t,resu_exp,couleur2,label="Exponnentielle")
plt.xlabel("temps (s)")
plt.ylabel("Concentration (mol.L-1)")
plt.legend()
plt.show()
