﻿
# titrage d'un acide fort par une base forte

import math
import matplotlib.pyplot as plt


resu_t=[]
resu_c1=[]
resu_c2=[]
resu_exp=[]

t1=1.0       # temps de demi_réaction en seconde
tfinal=500.0
k1=math.log(2)/t1   # constante de cinetique
k2=10
c1_0=0.1       # concentration initiale en espèce 1 en mol.L-1
c1=c1_0      # valeur à l'instant t
c2_0=0.0001
c2=c2_0
delta_t=0.1   # pas de temps en seconde
resu_c1.append(c1_0)
resu_c2.append(c2_0)
resu_exp.append(c1_0)
t=0
resu_t.append(t)
delta_x=0

def vitesse():
    c=max(c1,0)
    return k1*c*k2*c2*c

def calc_exp(t):
    return c1_0*math.exp(-k1*t)

couleur='#FF8000'
couleur2="#0000FF"
couleur3="#00FF00"

nbpoints=int(tfinal/delta_t)
for i in range(nbpoints+1):
    t=t+delta_t
    resu_t.append(t)
    delta_x=vitesse()*delta_t
    c1=c1-delta_x
    c2=c2+delta_x
    resu_c1.append(c1)
    resu_c2.append(c2)
    resu_exp.append(calc_exp(t))

#plt.plot(resu_t,resu_exp,couleur2,label="Exponentielle")
plt.plot(resu_t,resu_c1,couleur, label = "c1 t1/2 = "+str(t1)+" s (Euler)")
plt.plot(resu_t,resu_c2,couleur3, label = "c2 t1/2 = "+str(t1)+" s (Euler)")
#plt.plot(resu_t,resu_exp,couleur2,label="Exponnentielle")
plt.xlabel("temps (s)")
plt.ylabel("Concentration (mol.L-1)")
plt.legend()
plt.show()
