﻿
# titrage d'un acide fort par une base forte

import math
import matplotlib.pyplot as plt


resu_t=[]
resu_c1=[]
resu_exp=[]

t1=10.0       # temps de demi_réaction en seconde
tfinal=100.0
k1=math.log(2)/t1   # constante de cinetique
c1_0=0.1       # concentration initiale en espèce 1 en mol.L-1
c1=c1_0      # valeur à l'instant t
delta_t=0.1   # pas de temps en seconde
resu_c1.append(c1_0)
resu_exp.append(c1_0)
t=0
resu_t.append(t)

def vitesse():
    return k1*c1

def calc_exp(t):
    return c1_0*math.exp(-k1*t)

couleur='#FF8000'
couleur2="#0000FF"


nbpoints=int(tfinal/delta_t)
for i in range(nbpoints+1):
    t=t+delta_t
    resu_t.append(t)
    c1=c1-vitesse()*delta_t
    resu_c1.append(c1)
    resu_exp.append(calc_exp(t))

plt.plot(resu_t,resu_exp,couleur2,label="Exponentielle")
plt.plot(resu_t,resu_c1,couleur, label = "t1/2 = "+str(t1)+" s (Euler)")
#plt.plot(resu_t,resu_exp,couleur2,label="Exponentielle")
plt.xlabel("temps (s)")
plt.ylabel("Concentration (mol.L-1)")
plt.legend()
plt.show()
