﻿
# titrage d'un acide fort par une base forte

import math
import matplotlib.pyplot as plt


resu_x=[]
resu_pH=[]

Ke=10**(-14)   # produit ionique de l'eau

VA=0.025   # volume de la solution en L à titrer
C0A=1.0e-5  # concentration solution à titrer


C0B=25.0e-6 #  est la concentration en mol . L-1 totale en espèce A (sous forme AH ou A-) titrante soude
VB=0      # volume versé de solution titrante
VBmax=0.020 # volume de solution titrante max en L

couleur='#FF8000'


nbpoints=200
for i in range(nbpoints+1):
    VB=i/nbpoints*VBmax
    #Vtot=V1+V2
    #for k in range(neq+1):
    #    xx[k]=0.1
    #    xx2[k]=0.0
    #calcul_iteratif()
    delta=(VA*C0A+VB*C0B)**2-4*(VB*C0B*VA*C0A-Ke*(VA+VB)**2)

    if delta<0 :
        print("Discriminant négatif = ",delta)
    else:
        x1=(VA*C0A+VB*C0B+math.sqrt(delta))/2
        x2=(VA*C0A+VB*C0B-math.sqrt(delta))/2
        C1A=(VA*C0A-x1)/(VA+VB)
        C2A=(VA*C0A-x2)/(VA+VB)
        C1B=(VB*C0B-x1)/(VA+VB)
        C2B=(VB*C0B-x2)/(VA+VB)


        resu_x.append(VB)
        pH = -math.log10(C2A)
        resu_pH.append(pH)

plt.plot(resu_x,resu_pH,couleur, label = "CA = "+str(C0A)+" mol.L-1  VA = "+str(VA)+" L  CB = "+str(C0B)+" mol.L-1")
plt.xlabel("Volume VB (L) (Veq = "+str(C0A/C0B*VA)+" L)")
plt.ylabel("pH")
plt.legend()
plt.show()
