﻿
# Cas particulier acide et base forts : un seul équilibre

# Calcul ponctuel du pH d'une solution : mélange d'une solution
# acide et d'une solution basique

import math


Ke=10**(-14)   # produit ionique de l'eau

VA=0.150   # volume de la solution A en L (acide fort)
VB=0.250  # volume de lasolution B en L  (base forte)

C0A=1.50e-3 #  est la concentration en mol . L-1  en acide introduit dans la solution A
C0B=2.0e-4 #  est la concentration en mol . L-1  en base introduite dans la solution B


delta=(VA*C0A+VB*C0B)**2-4*(VB*C0B*VA*C0A-Ke*(VA+VB)**2)

if delta<0 :
    print("Discriminant négatif = ",delta)
else:
    print("Discriminant positif = ",delta)
    x1=(VA*C0A+VB*C0B+math.sqrt(delta))/2
    x2=(VA*C0A+VB*C0B-math.sqrt(delta))/2

    print("Avancement : x1 = ",x1," mol  x2 = ",x2," mol")

    C1A=(VA*C0A-x1)/(VA+VB)
    C2A=(VA*C0A-x2)/(VA+VB)
    C1B=(VB*C0B-x1)/(VA+VB)
    C2B=(VB*C0B-x2)/(VA+VB)

    print("Concentration 1 H+ = ",C1A," mol.L-1    Concentration 2 H+ = ",C2A," mol.L-1")
    print("Concentration 1 HO- = ",C1B," mol.L-1     Concentration 2 HO- = ",C2B," mol.L-1")

    if C2A>0 :
        print("pH = ",str(-math.log10(C2A)))

print("Fin du programme")


